/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.test;

import java.security.Provider;
import java.security.Security;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class FipsModeUtil {
    private FipsModeUtil() {
    }

    public static Optional<String> findFipsProvider(List<String> providersToMatch) {
        Provider[] jdkProviders = Security.getProviders();
        int matchCount = 0;
        for (Provider provider : jdkProviders) {
            if (providersToMatch.isEmpty() && provider.getName().toLowerCase().contains("fips")) {
                return Optional.of(provider.getName());
            }
            if (!providersToMatch.contains(provider.getName())) continue;
            ++matchCount;
        }
        if (!providersToMatch.isEmpty() && matchCount == providersToMatch.size()) {
            return Optional.empty();
        }
        return null;
    }

    public static boolean isFipsMode() {
        return FipsModeUtil.findFipsProvider(Collections.emptyList()) != null;
    }
}

