/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.test;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Optional;
import org.apache.camel.quarkus.test.DisabledOnQuarkusPlatform;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;

public class DisabledOnQuarkusPlatformCondition
implements ExecutionCondition {
    private static final ConditionEvaluationResult ENABLED_BY_DEFAULT = ConditionEvaluationResult.enabled((String)"@DisabledOnQuarkusPlatform: enabled - annotation not present");

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        return AnnotationUtils.findAnnotation((Optional)context.getElement(), DisabledOnQuarkusPlatform.class).isPresent() ? this.evaluate() : ENABLED_BY_DEFAULT;
    }

    private ConditionEvaluationResult evaluate() {
        if (Files.exists(Paths.get("src/main/java", new String[0]), new LinkOption[0])) {
            return ConditionEvaluationResult.enabled((String)"@DisabledOnQuarkusPlatform: enabled - Quarkus Platform not detected");
        }
        return ConditionEvaluationResult.disabled((String)"@DisabledOnQuarkusPlatform: disabled - Quarkus Platform detected");
    }
}

