/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.test;

import java.util.List;
import java.util.Optional;
import org.apache.camel.quarkus.test.EnabledIfFipsMode;
import org.apache.camel.quarkus.test.FipsModeUtil;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;

public class EnabledIfFipsModeCondition
implements ExecutionCondition {
    private static final ConditionEvaluationResult ENABLED_BY_DEFAULT = ConditionEvaluationResult.enabled((String)"@EnabledIfFipsMode is not present");

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        return AnnotationUtils.findAnnotation((Optional)context.getElement(), EnabledIfFipsMode.class).map(this::map).orElse(ENABLED_BY_DEFAULT);
    }

    private ConditionEvaluationResult map(EnabledIfFipsMode annotation) {
        List<String> providersToMatch = List.of(annotation.providers());
        Optional<String> fipsProviders = FipsModeUtil.findFipsProvider(providersToMatch);
        if (fipsProviders == null) {
            return ConditionEvaluationResult.disabled((String)"No FIPS security providers were detected");
        }
        if (fipsProviders.isEmpty()) {
            return ConditionEvaluationResult.enabled((String)"Detected FIPS security providers");
        }
        return ConditionEvaluationResult.enabled((String)("Detected FIPS security provider " + fipsProviders.get()));
    }
}

