/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.test;

import io.quarkus.test.junit.QuarkusIntegrationTest;
import io.quarkus.test.junit.main.QuarkusMainIntegrationTest;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.quarkus.test.DisabledOnRhel;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;

public class DisabledOnRhelCondition
implements ExecutionCondition {
    private static final ConditionEvaluationResult ENABLED_BY_DEFAULT = ConditionEvaluationResult.enabled((String)"@DisabledOnRhel: enabled - annotation not present");

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        boolean it = AnnotationUtils.findAnnotation((Optional)context.getTestClass(), QuarkusIntegrationTest.class).isPresent() || AnnotationUtils.findAnnotation((Optional)context.getTestClass(), QuarkusMainIntegrationTest.class).isPresent();
        Optional annotation = AnnotationUtils.findAnnotation((Optional)context.getElement(), DisabledOnRhel.class);
        return annotation.isPresent() ? this.evaluate(((DisabledOnRhel)annotation.get()).version(), ((DisabledOnRhel)annotation.get()).integrationTests(), it) : ENABLED_BY_DEFAULT;
    }

    private ConditionEvaluationResult evaluate(int version, boolean shouldDisableOnIt, boolean it) {
        return this.evaluate(System.getProperty("os.name").toLowerCase(), System.getProperty("os.version").toLowerCase(), version, shouldDisableOnIt, it);
    }

    ConditionEvaluationResult evaluate(String osName, String osVersion, int version, boolean shouldDisableOnIt, boolean it) {
        Pattern r = Pattern.compile(".+el(\\d+).+");
        Matcher m = r.matcher(osVersion.toLowerCase());
        if (osName.toLowerCase().contains("linux") && m.matches()) {
            if (version == 0) {
                return ConditionEvaluationResult.disabled((String)"@DisabledOnRhel: disable - RHEL");
            }
            Integer rhelVersion = Integer.parseInt(m.group(1));
            if (version == rhelVersion) {
                if (shouldDisableOnIt && it) {
                    return ConditionEvaluationResult.disabled((String)("@DisabledOnRhel(" + version + ", native = true) : disable - RHEL"));
                }
                if (!shouldDisableOnIt) {
                    return ConditionEvaluationResult.disabled((String)("@DisabledOnRhel(" + version + ") : disable - RHEL"));
                }
            }
        }
        return ConditionEvaluationResult.enabled((String)"@DisabledOnRhel: enabled - not a RHEL / or native");
    }
}

