/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.test;

import java.util.Optional;
import org.apache.camel.quarkus.test.DisabledOnArm;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;

public class DisabledOnArmCondition
implements ExecutionCondition {
    private static final ConditionEvaluationResult ENABLED_BY_DEFAULT = ConditionEvaluationResult.enabled((String)"@DisabledOnArm: enabled - annotation not present");

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        return AnnotationUtils.findAnnotation((Optional)context.getElement(), DisabledOnArm.class).isPresent() ? this.evaluate() : ENABLED_BY_DEFAULT;
    }

    private ConditionEvaluationResult evaluate() {
        if ("aarch64".equals(System.getProperty("os.arch"))) {
            if (System.getProperty("os.name").toLowerCase().contains("mac")) {
                return ConditionEvaluationResult.enabled((String)"@DisabledOnArm: enable - MAC ARM");
            }
            return ConditionEvaluationResult.disabled((String)"@DisabledOnArm: disable - non-MAC ARM");
        }
        return ConditionEvaluationResult.enabled((String)"@DisabledOnArm: enabled - not an ARM architecture");
    }
}

