/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.test;

import java.util.List;
import java.util.Optional;
import org.apache.camel.quarkus.test.DisabledIfFipsMode;
import org.apache.camel.quarkus.test.EnabledIfFipsModeCondition;
import org.apache.camel.quarkus.test.FipsModeUtil;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;

public class DisabledIfFipsModeCondition
extends EnabledIfFipsModeCondition {
    private static final ConditionEvaluationResult ENABLED_BY_DEFAULT = ConditionEvaluationResult.enabled((String)"@DisabledIfFipsMode is not present");

    @Override
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        return AnnotationUtils.findAnnotation((Optional)context.getElement(), DisabledIfFipsMode.class).map(this::map).orElse(ENABLED_BY_DEFAULT);
    }

    private ConditionEvaluationResult map(DisabledIfFipsMode annotation) {
        List<String> providersToMatch = List.of(annotation.providers());
        Optional<String> fipsProviders = FipsModeUtil.findFipsProvider(providersToMatch);
        if (fipsProviders == null) {
            return ConditionEvaluationResult.enabled((String)"No FIPS security providers were detected");
        }
        if (fipsProviders.isEmpty()) {
            return ConditionEvaluationResult.disabled((String)"Detected FIPS security providers");
        }
        return ConditionEvaluationResult.disabled((String)("Detected FIPS security provider " + fipsProviders.get()));
    }
}

