/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.test;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AvailablePortFinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(AvailablePortFinder.class);
    private static final Map<Integer, String> RESERVED_PORTS = new ConcurrentHashMap<Integer, String>();
    private static final String[] QUARKUS_PORT_PROPERTIES = new String[]{"quarkus.http.test-port", "quarkus.http.test-ssl-port", "quarkus.https.test-port"};

    private AvailablePortFinder() {
    }

    public static int getNextAvailable() {
        return AvailablePortFinder.getNextAvailable(Protocol.TCP);
    }

    public static int getNextAvailable(Protocol protocol) {
        AvailablePortFinder.logWarningIfNativeApplication();
        try {
            String callerClassName;
            int port;
            while (true) {
                if (AvailablePortFinder.isQuarkusReservedPort(port = protocol.getPort())) {
                    continue;
                }
                callerClassName = AvailablePortFinder.getCallerClassName();
                String value = RESERVED_PORTS.putIfAbsent(port, callerClassName);
                if (value == null) break;
            }
            LOGGER.info("{} reserved port {}", (Object)callerClassName, (Object)port);
            return port;
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot find free port", e);
        }
    }

    public static Map<String, Integer> reserveNetworkPorts(String ... names) {
        return AvailablePortFinder.reserveNetworkPorts(Function.identity(), names);
    }

    public static Map<String, Integer> reserveNetworkPorts(Protocol protocol, String ... names) {
        return AvailablePortFinder.reserveNetworkPorts(protocol, Function.identity(), names);
    }

    public static <T> Map<String, T> reserveNetworkPorts(Function<Integer, T> converter, String ... names) {
        return AvailablePortFinder.reserveNetworkPorts(Protocol.TCP, converter, names);
    }

    public static <T> Map<String, T> reserveNetworkPorts(Protocol protocol, Function<Integer, T> converter, String ... names) {
        HashMap<String, T> reservedPorts = new HashMap<String, T>();
        for (String name : names) {
            reservedPorts.put(name, converter.apply(AvailablePortFinder.getNextAvailable(protocol)));
        }
        return reservedPorts;
    }

    public static void releaseReservedPorts() {
        String callerClassName = AvailablePortFinder.getCallerClassName();
        RESERVED_PORTS.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(callerClassName)).peek(entry -> LOGGER.info("Releasing port {} reserved by {}", entry.getKey(), entry.getValue())).map(Map.Entry::getKey).forEach(RESERVED_PORTS::remove);
    }

    private static boolean isQuarkusReservedPort(int port) {
        Config config = ConfigProvider.getConfig();
        for (String property : QUARKUS_PORT_PROPERTIES) {
            Optional portProperty = config.getOptionalValue(property, Integer.class);
            if (!portProperty.isPresent() || port != (Integer)portProperty.get()) continue;
            LOGGER.info("Port {} is already reserved for {}", (Object)port, (Object)property);
            return true;
        }
        return false;
    }

    private static String getCallerClassName() {
        return StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).walk(s -> s.map(StackWalker.StackFrame::getClassName).filter(className -> !className.equals(AvailablePortFinder.class.getName())).findFirst().orElseThrow(IllegalStateException::new));
    }

    private static void logWarningIfNativeApplication() {
        if (System.getProperty("org.graalvm.nativeimage.kind") != null) {
            LOGGER.warn("Usage of AvailablePortFinder in the native application is discouraged. Pass the reserved port to the native application under test with QuarkusTestResourceLifecycleManager or via an HTTP request");
        }
    }

    public static enum Protocol {
        TCP,
        UDP;


        int getPort() throws IOException {
            if (this.equals((Object)TCP)) {
                try (ServerSocket socket = new ServerSocket();){
                    socket.setReuseAddress(true);
                    socket.bind(null);
                    int n = socket.getLocalPort();
                    return n;
                }
            }
            try (DatagramSocket socket = new DatagramSocket();){
                socket.setReuseAddress(true);
                int n = socket.getLocalPort();
                return n;
            }
        }
    }
}

