/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.test;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;

public class TrustStoreResource
implements QuarkusTestResourceLifecycleManager {
    private static final String CACERTS_REL_PATH = "lib/security/cacerts";
    private static final String CACERTS_REL_PATH_ALT = "jre/lib/security/cacerts";

    public Map<String, String> start() {
        Path trustStorePath;
        String graalVmHome = System.getenv("GRAALVM_HOME");
        String javaHome = System.getProperty("java.home", System.getenv("JAVA_HOME"));
        if (!(graalVmHome != null && !graalVmHome.isEmpty() && Files.exists(trustStorePath = Paths.get(graalVmHome, new String[0]).resolve(CACERTS_REL_PATH), new LinkOption[0]) || javaHome != null && !javaHome.isEmpty() && Files.exists(trustStorePath = Paths.get(javaHome, new String[0]).resolve(CACERTS_REL_PATH), new LinkOption[0]) || javaHome != null && !javaHome.isEmpty() && Files.exists(trustStorePath = Paths.get(javaHome, new String[0]).resolve(CACERTS_REL_PATH_ALT), new LinkOption[0]))) {
            throw new IllegalStateException("Could not find any existing file to set javax.net.ssl.trustStore; tried $GRAALVM_HOME/lib/security/cacerts and $JAVA_HOME/lib/security/cacerts. You may need to set GRAALVM_HOME or JAVA_HOME properly. Found $GRAALVM_HOME = " + graalVmHome + " and $JAVA_HOME = " + graalVmHome);
        }
        return Collections.singletonMap("javax.net.ssl.trustStore", trustStorePath.toString());
    }

    public void stop() {
    }
}

