/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.test;

import java.util.Optional;
import java.util.function.BooleanSupplier;
import org.apache.camel.quarkus.test.EnabledIf;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;

class EnabledIfCondition
implements ExecutionCondition {
    private static final ConditionEvaluationResult ENABLED_BY_DEFAULT = ConditionEvaluationResult.enabled((String)"@EnabledIf is not present");

    EnabledIfCondition() {
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        return AnnotationUtils.findAnnotation((Optional)context.getElement(), EnabledIf.class).map(this::map).orElse(ENABLED_BY_DEFAULT);
    }

    private ConditionEvaluationResult map(EnabledIf annotation) {
        for (Class<? extends BooleanSupplier> type : annotation.value()) {
            try {
                if (type.newInstance().getAsBoolean()) continue;
                return ConditionEvaluationResult.disabled((String)String.format("Condition %s is false", type.getName()));
            }
            catch (IllegalAccessException | InstantiationException e) {
                return ConditionEvaluationResult.disabled((String)String.format("Unable to evaluate condition: %s", type.getName()));
            }
        }
        return ConditionEvaluationResult.enabled((String)"All conditions match");
    }
}

