/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.test;

import java.util.Map;
import java.util.Objects;
import org.assertj.core.api.Condition;

public final class Conditions {
    private Conditions() {
    }

    public static Condition<Map.Entry<String, String>> entry(final String key, final String value) {
        return new Condition<Map.Entry<String, String>>(){

            public boolean matches(Map.Entry<String, String> entry) {
                return Objects.equals(entry.getKey(), key) && Objects.equals(entry.getValue(), value);
            }
        };
    }

    public static Condition<String> startsWith(final String prefix) {
        return new Condition<String>("Starts with " + prefix){

            public boolean matches(String value) {
                return value.startsWith(prefix);
            }
        };
    }

    public static Condition<String> doesNotStartWith(final String prefix) {
        return new Condition<String>("Does not start with " + prefix){

            public boolean matches(String value) {
                return !value.startsWith(prefix);
            }
        };
    }
}

