/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.test;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AvailablePortFinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(AvailablePortFinder.class);

    private AvailablePortFinder() {
    }

    public static int getNextAvailable() {
        int n;
        ServerSocket ss = new ServerSocket();
        try {
            ss.setReuseAddress(true);
            ss.bind(new InetSocketAddress((InetAddress)null, 0), 1);
            int port = ss.getLocalPort();
            LOGGER.info("getNextAvailable() -> {}", (Object)port);
            n = port;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ss.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot find free port", e);
            }
        }
        ss.close();
        return n;
    }

    public static Map<String, Integer> reserveNetworkPorts(String ... names) {
        return AvailablePortFinder.reserveNetworkPorts(Function.identity(), names);
    }

    public static <T> Map<String, T> reserveNetworkPorts(Function<Integer, T> converter, String ... names) {
        HashMap<String, T> reservedPorts = new HashMap<String, T>();
        for (String name : names) {
            reservedPorts.put(name, converter.apply(AvailablePortFinder.getNextAvailable()));
        }
        return reservedPorts;
    }
}

