/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.stringtemplate.it;

import java.net.URI;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.jboss.logging.Logger;

@Path(value="/stringtemplate")
@ApplicationScoped
public class StringtemplateResource {
    private static final Logger LOG = Logger.getLogger(StringtemplateResource.class);
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/template")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public Response post(Map<String, Object> headers, @QueryParam(value="template") String template, @QueryParam(value="body") String body, @QueryParam(value="parameters") String parameters) throws Exception {
        LOG.infof("Sending to stringtemplate: %s", headers);
        String endpointUri = "string-template:" + template + (String)(parameters != null ? "?" + parameters : "");
        Exchange response = this.producerTemplate.request(endpointUri, exchange -> {
            exchange.getIn().setBody((Object)body);
            exchange.getIn().setHeaders(headers);
        });
        LOG.infof("Got response from stringtemplate: %s", response.getMessage().getBody());
        return Response.created((URI)new URI("https://camel.apache.org/")).entity(response.getMessage().getBody()).build();
    }
}

