/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.stringtemplate.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.jupiter.api.Test;

@QuarkusTest
class StringtemplateTest {
    StringtemplateTest() {
    }

    @Test
    public void testTemplateFromClasspath() {
        HashMap headers = new HashMap(){
            {
                this.put("name", "Sheldon");
                this.put("item", "Camel in Action");
            }
        };
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("body", new Object[]{"PS: Next beer is on me!"}).queryParam("template", new Object[]{"//template/letter.tm"}).contentType(ContentType.JSON).body((Object)headers).post("/stringtemplate/template", new Object[0])).then()).statusCode(201)).body(CoreMatchers.containsString((String)"Dear Sheldon! Thanks for the order of Camel in Action. Regards Camel Riders Bookstore PS: Next beer is on me!"), new Matcher[0]);
    }

    @Test
    public void testVariableMap() {
        final HashMap<String, Object> variableMap = new HashMap<String, Object>();
        HashMap<String, String> headersMap = new HashMap<String, String>();
        headersMap.put("name", "Willem");
        variableMap.put("headers", headersMap);
        variableMap.put("body", "Monday");
        variableMap.put("item", "1");
        HashMap headers = new HashMap(){
            {
                this.put("name", "Sheldon");
                this.put("item", "7");
                this.put("CamelStringTemplateVariableMap", variableMap);
            }
        };
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("body", new Object[]{""}).queryParam("template", new Object[]{"//template/template.tm"}).queryParam("parameters", new Object[]{"allowTemplateFromHeader=true"}).contentType(ContentType.JSON).body((Object)headers).post("/stringtemplate/template", new Object[0])).then()).statusCode(201)).body(CoreMatchers.containsString((String)"Dear Willem. You ordered item 1 on Monday."), new Matcher[0]);
    }

    @Test
    public void testWithBraceDelimiter() {
        this.testWithDelimiter("{", "}", "With brace delimiter ", "custom-delimiter-brace.tm");
    }

    @Test
    public void testWithDollarDelimiter() {
        this.testWithDelimiter("$", "$", "With identical dollar delimiter ", "custom-delimiter-dollar.tm");
    }

    private void testWithDelimiter(String start, String stop, String text, String template) {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("body", new Object[]{"WORKS!"}).queryParam("template", new Object[]{"//template/" + template}).queryParam("parameters", new Object[]{"delimiterStart=" + start + "&delimiterStop=" + stop}).contentType(ContentType.JSON).body(Collections.emptyMap()).post("/stringtemplate/template", new Object[0])).then()).statusCode(201)).body(CoreMatchers.containsString((String)(text + "WORKS!\n")), new Matcher[0]);
    }

    @Test
    public void testContentCacheFalse() throws Exception {
        this.testContentCache(false);
    }

    @Test
    public void testContentCacheTrue() throws Exception {
        this.testContentCache(true);
    }

    private void testContentCache(boolean useContentCache) throws Exception {
        File template = this.createFile("stringtemplate", "Hi <headers.name>");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("template", new Object[]{"file:" + template.getPath()}).queryParam("parameters", new Object[]{"contentCache=" + useContentCache}).contentType(ContentType.JSON).body(Collections.singletonMap("name", "Sheldon")).post("/stringtemplate/template", new Object[0])).then()).statusCode(201)).body(CoreMatchers.equalTo((Object)"Hi Sheldon"), new Matcher[0]);
        Files.write(Paths.get(template.getPath(), new String[0]), "Bye <headers.name>".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("template", new Object[]{"file:" + template.getPath()}).queryParam("parameters", new Object[]{"contentCache=" + useContentCache}).contentType(ContentType.JSON).body(Collections.singletonMap("name", "Sheldon")).body(Collections.singletonMap("name", "Sheldon")).post("/stringtemplate/template", new Object[0])).then()).statusCode(201)).body(CoreMatchers.equalTo((Object)(useContentCache ? "Hi Sheldon" : "Bye Sheldon")), new Matcher[0]);
    }

    private File createFile(String fileName, String body) throws IOException {
        File tmpFile = File.createTempFile(fileName, ".tm");
        Files.write(tmpFile.toPath(), body.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        tmpFile.deleteOnExit();
        return tmpFile;
    }
}

