/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.stax.it;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.io.InputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.quarkus.component.stax.it.TagCountHandler;
import org.apache.camel.quarkus.component.stax.it.model.Record;

@Path(value="/stax")
public class StaxResource {
    @Inject
    CamelContext context;
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/records")
    @GET
    @Produces(value={"text/plain"})
    public int staxProcessRecords() throws Exception {
        try (InputStream resource = StaxResource.class.getResourceAsStream("/records.xml");){
            TagCountHandler countingHandler = (TagCountHandler)this.producerTemplate.requestBody("direct:processRecords", (Object)resource, TagCountHandler.class);
            int n = countingHandler.getCount();
            return n;
        }
    }

    @Path(value="/records/byref")
    @GET
    @Produces(value={"text/plain"})
    public int staxProcessRecordsByRef() throws Exception {
        try (InputStream resource = StaxResource.class.getResourceAsStream("/records.xml");){
            TagCountHandler countingHandler = (TagCountHandler)this.producerTemplate.requestBody("direct:processRecordsByRef", (Object)resource, TagCountHandler.class);
            int n = countingHandler.getCount();
            return n;
        }
    }

    @Path(value="/records/split")
    @GET
    @Produces(value={"text/plain"})
    public void staxSplitRecords() throws Exception {
        try (InputStream resource = StaxResource.class.getResourceAsStream("/records.xml");){
            MockEndpoint mockEndpoint = (MockEndpoint)this.context.getEndpoint("mock:split", MockEndpoint.class);
            mockEndpoint.expectedMessageCount(10);
            ((MockValueBuilder)mockEndpoint.allMessages().body()).isInstanceOf(Record.class);
            this.producerTemplate.sendBody("direct:splitRecords", (Object)resource);
            mockEndpoint.assertIsSatisfied();
        }
    }

    @jakarta.enterprise.inject.Produces
    @Named(value="countingHandler")
    public TagCountHandler countingHandler() {
        return new TagCountHandler();
    }
}

