/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.stax.it;

import java.io.InputStream;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.quarkus.component.stax.it.TagCountHandler;
import org.apache.camel.quarkus.component.stax.it.model.Record;

@Path(value="/stax")
public class StaxResource {
    @Inject
    CamelContext context;
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/records")
    @GET
    @javax.ws.rs.Produces(value={"text/plain"})
    public int staxProcessRecords() throws Exception {
        try (InputStream resource = StaxResource.class.getResourceAsStream("/records.xml");){
            TagCountHandler countingHandler = (TagCountHandler)this.producerTemplate.requestBody("direct:processRecords", (Object)resource, TagCountHandler.class);
            int n = countingHandler.getCount();
            return n;
        }
    }

    @Path(value="/records/byref")
    @GET
    @javax.ws.rs.Produces(value={"text/plain"})
    public int staxProcessRecordsByRef() throws Exception {
        try (InputStream resource = StaxResource.class.getResourceAsStream("/records.xml");){
            TagCountHandler countingHandler = (TagCountHandler)this.producerTemplate.requestBody("direct:processRecordsByRef", (Object)resource, TagCountHandler.class);
            int n = countingHandler.getCount();
            return n;
        }
    }

    @Path(value="/records/split")
    @GET
    @javax.ws.rs.Produces(value={"text/plain"})
    public void staxSplitRecords() throws Exception {
        try (InputStream resource = StaxResource.class.getResourceAsStream("/records.xml");){
            MockEndpoint mockEndpoint = (MockEndpoint)this.context.getEndpoint("mock:split", MockEndpoint.class);
            mockEndpoint.expectedMessageCount(10);
            ((MockValueBuilder)mockEndpoint.allMessages().body()).isInstanceOf(Record.class);
            this.producerTemplate.sendBody("direct:splitRecords", (Object)resource);
            mockEndpoint.assertIsSatisfied();
        }
    }

    @Produces
    @Named(value="countingHandler")
    public TagCountHandler countingHandler() {
        return new TagCountHandler();
    }
}

