/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.ssh.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.camel.ProducerTemplate;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Path(value="/ssh")
@ApplicationScoped
public class SshResource {
    private final String user = "test";
    private final String password = "password";
    @ConfigProperty(name="quarkus.ssh.host")
    private String host;
    @ConfigProperty(name="quarkus.ssh.port")
    private String port;
    @Inject
    ProducerTemplate producerTemplate;

    @POST
    @Path(value="/file/{fileName}")
    @Consumes(value={"text/plain"})
    public Response writeToFile(@PathParam(value="fileName") String fileName, String content) throws URISyntaxException {
        String sshWriteFileCommand = String.format("printf \"%s\" > %s", content, fileName);
        this.producerTemplate.sendBody(String.format("ssh:%s:%s?username=%s&password=%s", this.host, this.port, "test", "password"), (Object)sshWriteFileCommand);
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }

    @GET
    @Path(value="/file/{fileName}")
    @Produces(value={"text/plain"})
    public Response readFile(@PathParam(value="fileName") String fileName) throws URISyntaxException {
        String sshReadFileCommand = String.format("cat %s", fileName);
        String content = (String)this.producerTemplate.requestBody(String.format("ssh:%s:%s?username=%s&password=%s", this.host, this.port, "test", "password"), (Object)sshReadFileCommand, String.class);
        return Response.ok((Object)content).build();
    }
}

