/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.ssh.it;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.Map;
import org.apache.camel.util.CollectionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.TestcontainersConfiguration;

public class SshTestResource
implements QuarkusTestResourceLifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SshTestResource.class);
    private static final int SSH_PORT = 2222;
    private static final String SSH_IMAGE = "linuxserver/openssh-server";
    private GenericContainer container;

    public Map<String, String> start() {
        LOGGER.info(TestcontainersConfiguration.getInstance().toString());
        LOGGER.info("Starting SSH container");
        try {
            this.container = new GenericContainer(SSH_IMAGE).withExposedPorts(new Integer[]{2222}).withEnv("PASSWORD_ACCESS", "true").withEnv("USER_NAME", "test").withEnv("USER_PASSWORD", "password").waitingFor((WaitStrategy)Wait.forListeningPort());
            this.container.start();
            LOGGER.info("Started SSH container to {}:{}", (Object)this.container.getHost(), (Object)this.container.getMappedPort(2222).toString());
            return CollectionHelper.mapOf((Object)"quarkus.ssh.host", (Object)this.container.getHost(), (Object[])new Object[]{"quarkus.ssh.port", this.container.getMappedPort(2222).toString()});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        LOGGER.info("Stopping SSH container");
        try {
            if (this.container != null) {
                this.container.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

