/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.sql.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.camel.util.CollectionHelper;
import org.awaitility.Awaitility;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsMapContaining;
import org.hamcrest.text.IsEqualIgnoringCase;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIfSystemProperty;

@QuarkusTest
class SqlTest {
    SqlTest() {
    }

    @Test
    public void testSqlComponent() {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).queryParam("table", new Object[]{"camel"}).body((Object)CollectionHelper.mapOf((Object)"species", (Object)"Dromedarius", (Object[])new Object[0])).post("/sql/insert", new Object[0])).then()).statusCode(201);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/sql/get/Dromedarius", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.containsStringIgnoringCase((String)"[{ID=1, SPECIES=Dromedarius}]"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/sql/get/Dromedarius/list", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)"Dromedarius 1"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/sql/get/Dromedarius/list/type", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)"Dromedarius 1"), new Matcher[0]);
    }

    @Test
    @DisabledIfSystemProperty(named="cq.sqlJdbcKind", matches="[^h][^2].*", disabledReason="https://github.com/apache/camel-quarkus/issues/3080")
    public void testSqlStoredComponent() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("numA", new Object[]{10}).queryParam("numB", new Object[]{5}).get("/sql/storedproc", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"15"), new Matcher[0]);
    }

    @Test
    public void testConsumer() throws InterruptedException {
        this.testConsumer(1, "consumerRoute", "ViaSql");
    }

    @Test
    public void testClasspathConsumer() throws InterruptedException {
        this.testConsumer(2, "consumerClasspathRoute", "ViaClasspath");
    }

    @Test
    public void testFileConsumer() throws InterruptedException {
        this.testConsumer(3, "consumerFileRoute", "ViaFile");
    }

    private void testConsumer(int id, String routeId, String via) throws InterruptedException {
        Map project = CollectionHelper.mapOf((Object)"ID", (Object)id, (Object[])new Object[]{"PROJECT", routeId, "LICENSE", "222", "PROCESSED", false});
        Map updatedProject = CollectionHelper.mapOf((Object)"ID", (Object)id, (Object[])new Object[]{"PROJECT", routeId, "LICENSE", "XXX", "PROCESSED", false});
        this.postMapWithParam("/sql/insert", "table", "projects" + via, project).statusCode(201);
        Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> (Iterable)((ValidatableResponse)RestAssured.get((String)("/sql/get/results/" + routeId), (Object[])new Object[0]).then()).extract().as(List.class), Matchers.hasItem(SqlTest.matchMapIgnoringCase(project)));
        this.postMapWithParam("/sql/update", "table", "projects" + via, updatedProject).statusCode(201);
        Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> (Iterable)((ValidatableResponse)RestAssured.get((String)("/sql/get/results/" + routeId), (Object[])new Object[0]).then()).extract().as(List.class), Matchers.hasItem(SqlTest.matchMapIgnoringCase(updatedProject)));
    }

    @Test
    public void testTransacted() throws InterruptedException {
        this.postMap("/sql/toDirect/transacted", CollectionHelper.mapOf((Object)"CamelSqlQuery", (Object)"insert into projectsViaSql values (5, 'Transacted', 'ASF', BOOLEAN_FALSE)", (Object[])new Object[]{"rollback", false})).statusCode(204);
        ((ValidatableResponse)this.postMap("/sql/toDirect/transacted", CollectionHelper.mapOf((Object)"CamelSqlQuery", (Object)"select * from projectsViaSql where project = 'Transacted'", (Object[])new Object[0])).statusCode(200)).body("size()", Matchers.is((Object)1), new Object[0]);
        ((ValidatableResponse)this.postMap("/sql/toDirect/transacted", CollectionHelper.mapOf((Object)"CamelSqlQuery", (Object)"insert into projectsViaSql values (6, 'Transacted', 'ASF', BOOLEAN_FALSE)", (Object[])new Object[]{"rollback", true})).statusCode(200)).body(Matchers.is((Object)"java.lang.Exception:forced Exception"), new Matcher[0]);
        ((ValidatableResponse)this.postMap("/sql/toDirect/transacted", CollectionHelper.mapOf((Object)"CamelSqlQuery", (Object)"select * from projectsViaSql where project = 'Transacted'", (Object[])new Object[0])).statusCode(200)).body("size()", Matchers.is((Object)1), new Object[0]);
    }

    @Test
    public void testDefaultErrorCode() throws InterruptedException {
        ((ValidatableResponse)this.postMap("/sql/toDirect/transacted", CollectionHelper.mapOf((Object)"CamelSqlQuery", (Object)"select * from NOT_EXIST", (Object[])new Object[0])).statusCode(200)).body(Matchers.startsWith((String)"org.springframework.jdbc.BadSqlGrammarException"), new Matcher[0]);
    }

    @Test
    public void testIdempotentRepository() {
        this.postMapWithParam("/sql/toDirect/idempotent", "body", "one", CollectionHelper.mapOf((Object)"messageId", (Object)"1", (Object[])new Object[0])).statusCode(200);
        this.postMapWithParam("/sql/toDirect/idempotent", "body", "two", CollectionHelper.mapOf((Object)"messageId", (Object)"2", (Object[])new Object[0])).statusCode(200);
        this.postMapWithParam("/sql/toDirect/idempotent", "body", "three", CollectionHelper.mapOf((Object)"messageId", (Object)"3", (Object[])new Object[0])).statusCode(200);
        this.postMapWithParam("/sql/toDirect/idempotent", "body", "four", CollectionHelper.mapOf((Object)"messageId", (Object)"1", (Object[])new Object[0])).statusCode(200);
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(() -> (Iterable)((ValidatableResponse)RestAssured.get((String)"/sql/get/results/idempotentRoute", (Object[])new Object[0]).then()).extract().as(List.class), Matchers.containsInAnyOrder((Object[])new String[]{"one", "two", "three"}));
    }

    @Test
    public void testAggregationRepository() {
        this.postMapWithParam("/sql/toDirect/aggregation", "body", "A", CollectionHelper.mapOf((Object)"messageId", (Object)"123", (Object[])new Object[0])).statusCode(200);
        this.postMapWithParam("/sql/toDirect/aggregation", "body", "B", CollectionHelper.mapOf((Object)"messageId", (Object)"123", (Object[])new Object[0])).statusCode(200);
        this.postMapWithParam("/sql/toDirect/aggregation", "body", "C", CollectionHelper.mapOf((Object)"messageId", (Object)"123", (Object[])new Object[0])).statusCode(200);
        this.postMapWithParam("/sql/toDirect/aggregation", "body", "D", CollectionHelper.mapOf((Object)"messageId", (Object)"123", (Object[])new Object[0])).statusCode(200);
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(() -> (Iterable)((ValidatableResponse)RestAssured.get((String)"/sql/get/results/aggregationRoute", (Object[])new Object[0]).then()).extract().as(List.class), Matchers.containsInAnyOrder((Object[])new String[]{"ABCD"}));
    }

    private ValidatableResponse postMap(String toUrl, Map<String, String> body) {
        return this.postMapWithParam(toUrl, null, null, body);
    }

    private ValidatableResponse postMapWithParam(String toUrl, String param, String paramValue, Map<String, String> body) {
        RequestSpecification rs = RestAssured.given().contentType(ContentType.JSON);
        if (param != null) {
            rs = rs.queryParam(param, new Object[]{paramValue});
        }
        return (ValidatableResponse)((Response)rs.body(body).post(toUrl, new Object[0])).then();
    }

    public static Matcher<Map<String, Object>> matchMapIgnoringCase(Map<String, Object> map) {
        IsMapContaining m = null;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object fieldCondition = entry.getValue() instanceof Boolean ? Matchers.either((Matcher)new IsMapContaining((Matcher)new IsEqualIgnoringCase(entry.getKey()), Matchers.is((Object)entry.getValue()))).or((Matcher)new IsMapContaining((Matcher)new IsEqualIgnoringCase(entry.getKey()), Matchers.is((Object)((Boolean)entry.getValue() != false ? 1 : 0)))) : new IsMapContaining((Matcher)new IsEqualIgnoringCase(entry.getKey()), Matchers.is((Object)entry.getValue()));
            if (m == null) {
                m = fieldCondition;
                continue;
            }
            m = Matchers.both((Matcher)m).and((Matcher)fieldCondition);
        }
        return m;
    }
}

