/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.sql.it;

import io.agroal.api.AgroalDataSource;
import io.quarkus.agroal.DataSource;
import java.net.URI;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.quarkus.component.sql.it.model.Camel;
import org.springframework.util.LinkedCaseInsensitiveMap;

@Path(value="/sql")
@ApplicationScoped
public class SqlResource {
    @Inject
    @DataSource(value="camel-sql")
    AgroalDataSource dataSource;
    @Inject
    ProducerTemplate producerTemplate;

    @PostConstruct
    public void postConstruct() throws SQLException {
        try (Connection conn = this.dataSource.getConnection();
             Statement statement = conn.createStatement();){
            statement.execute("DROP TABLE IF EXISTS camel");
            statement.execute("CREATE TABLE camel (id int AUTO_INCREMENT, species VARCHAR(255))");
            statement.execute("CREATE ALIAS ADD_NUMS FOR \"org.apache.camel.quarkus.component.sql.it.storedproc.NumberAddStoredProcedure.addNumbers\"");
        }
    }

    @Path(value="/get/{species}")
    @GET
    @Produces(value={"text/plain"})
    public String getCamel(@PathParam(value="species") String species) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("species", species);
        return (String)this.producerTemplate.requestBodyAndHeaders("sql:classpath:sql/get-camels.sql", null, params, String.class);
    }

    @Path(value="/get/{species}/list")
    @GET
    @Produces(value={"text/plain"})
    public String getCamelSelectList(@PathParam(value="species") String species) throws Exception {
        List result = (List)this.producerTemplate.requestBody("sql:SELECT * FROM camel WHERE species = '" + species + "'?outputType=SelectList", null, List.class);
        if (result.isEmpty()) {
            throw new IllegalStateException("Expected at least 1 camel result but none were found");
        }
        LinkedCaseInsensitiveMap data = (LinkedCaseInsensitiveMap)result.get(0);
        return data.get((Object)"SPECIES") + " " + data.get((Object)"ID");
    }

    @Path(value="/get/{species}/list/type")
    @GET
    @Produces(value={"text/plain"})
    public String getCamelSelectListWithType(@PathParam(value="species") String species) throws Exception {
        List camels = (List)this.producerTemplate.requestBody("sql:SELECT * FROM camel WHERE species = '" + species + "'?outputType=SelectList&outputClass=org.apache.camel.quarkus.component.sql.it.model.Camel", null, List.class);
        if (camels.isEmpty()) {
            throw new IllegalStateException("Expected at least 1 camel result but none were found");
        }
        Camel result = (Camel)camels.get(0);
        return result.getSpecies() + " " + result.getId();
    }

    @Path(value="/post")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response createCamel(String species) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("species", species);
        this.producerTemplate.requestBodyAndHeaders("sql:INSERT INTO camel (species) VALUES (:#species)", null, params);
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }

    @Path(value="/storedproc")
    @GET
    @Produces(value={"text/plain"})
    public String callStoredProcedure(@QueryParam(value="numA") int numA, @QueryParam(value="numB") int numB) {
        HashMap<String, Integer> args = new HashMap<String, Integer>();
        args.put("num1", numA);
        args.put("num2", numB);
        Map results = (Map)this.producerTemplate.requestBodyAndHeaders("sql-stored:ADD_NUMS(INTEGER ${headers.num1},INTEGER ${headers.num2})", null, args, Map.class);
        return ((LinkedCaseInsensitiveMap)((List)results.get("#result-set-1")).get(0)).get((Object)"PUBLIC.ADD_NUMS(?1, ?2)").toString();
    }
}

