/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.splunk.hec.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.camel.quarkus.test.support.splunk.SplunkTestResource;
import org.eclipse.microprofile.config.ConfigProvider;
import org.junit.jupiter.api.Test;
import org.testcontainers.shaded.org.awaitility.Awaitility;
import org.testcontainers.shaded.org.hamcrest.core.StringContains;

@QuarkusTest
@QuarkusTestResource(value=SplunkTestResource.class)
class SplunkHecTest {
    SplunkHecTest() {
    }

    @Test
    public void produce() {
        String url = String.format("http://%s:%d", this.getConfigValue("org.apache.camel.quarkus.component.splunk.hec.it.SplunkHecResource_host", String.class), this.getConfigValue("org.apache.camel.quarkus.component.splunk.hec.it.SplunkHecResource_remotePort", Integer.class));
        ((ValidatableResponse)((Response)RestAssured.given().body("Hello Sheldon").post("/splunk-hec/send", new Object[0])).then()).statusCode(200);
        Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().request().formParam("search", new Object[]{"search index=\"testindex\""}).formParam("exec_mode", new Object[]{"oneshot"}).relaxedHTTPSValidation().auth().basic("admin", "password").post(url + "/services/search/jobs", new Object[0])).then()).statusCode(200)).extract().asString(), StringContains.containsString((String)"Hello Sheldon"));
    }

    @Test
    public void testIndexTime() {
        String url = String.format("http://%s:%d", this.getConfigValue("org.apache.camel.quarkus.component.splunk.hec.it.SplunkHecResource_host", String.class), this.getConfigValue("org.apache.camel.quarkus.component.splunk.hec.it.SplunkHecResource_remotePort", Integer.class));
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        ((ValidatableResponse)((Response)RestAssured.given().body("Hello time 01").post("/splunk-hec/send", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((Response)RestAssured.given().body("Hello time 02").queryParam("indexTime", new Object[]{calendar.getTimeInMillis()}).post("/splunk-hec/send", new Object[0])).then()).statusCode(200);
        Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> {
            List times01 = (List)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().request().formParam("search", new Object[]{"search body=\"hello time 01\" index=\"testindex\""}).formParam("exec_mode", new Object[]{"oneshot"}).formParam("output_mode", new Object[]{"json"}).relaxedHTTPSValidation().auth().basic("admin", "password").post(url + "/services/search/jobs", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).extract().path("results._time", new String[0]);
            List times02 = (List)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().request().formParam("search", new Object[]{"search body=\"hello time 02\" index=\"testindex\""}).formParam("exec_mode", new Object[]{"oneshot"}).formParam("output_mode", new Object[]{"json"}).relaxedHTTPSValidation().auth().basic("admin", "password").post(url + "/services/search/jobs", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).extract().path("results._time", new String[0]);
            return times01.size() == 1 && times02.size() == 1 && ((String)times02.get(0)).compareTo((String)times01.get(0)) < 1;
        });
    }

    private <T> T getConfigValue(String key, Class<T> type) {
        return (T)ConfigProvider.getConfig().getValue(key, type);
    }
}

