/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.splunk.hec.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Path(value="/splunk-hec")
@ApplicationScoped
public class SplunkHecResource {
    @Inject
    ProducerTemplate producer;
    @ConfigProperty(name="org.apache.camel.quarkus.component.splunk.hec.it.SplunkHecResource_hecPort")
    Integer hecPort;
    @ConfigProperty(name="org.apache.camel.quarkus.component.splunk.hec.it.SplunkHecResource_host")
    String host;
    @ConfigProperty(name="org.apache.camel.quarkus.component.splunk.hec.it.SplunkHecResource_testIndex")
    String index;
    @ConfigProperty(name="org.apache.camel.quarkus.component.splunk.hec.it.SplunkHecResource_hecToken")
    String token;

    @Path(value="/send/{sslContextParameters}")
    @POST
    @Produces(value={"text/plain"})
    public Response send(String data, @PathParam(value="sslContextParameters") String sslContextParameters, @QueryParam(value="indexTime") Long indexTime) {
        String url = String.format("splunk-hec:%s:%s?token=%s&sslContextParameters=#%s&skipTlsVerify=false&https=true&index=%s", this.host, this.hecPort, this.token, sslContextParameters, this.index);
        try {
            return Response.status((int)200).entity(this.producer.requestBodyAndHeader(url, (Object)data, "CamelSplunkHECIndexTime", (Object)indexTime, String.class)).build();
        }
        catch (Exception e) {
            if (e.getCause() instanceof SSLException) {
                return Response.status((int)500).entity((Object)"ssl exception").build();
            }
            throw new RuntimeException(e);
        }
    }

    @Named(value="sslContextParameters")
    public SSLContextParameters createServerSSLContextParameters() {
        return this.createServerSSLContextParameters("target/certs/splunk-hec-keystore.p12");
    }

    @Named(value="wrongSslContextParameters")
    public SSLContextParameters createWrongServerSSLContextParameters() {
        return this.createServerSSLContextParameters("target/certs/splunk-hec-invalid-keystore.p12");
    }

    private SSLContextParameters createServerSSLContextParameters(final String keystore) {
        return new SSLContextParameters(){

            public SSLContext createSSLContext(CamelContext camelContext) throws GeneralSecurityException, IOException {
                SSLContext sSLContext;
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init((KeyStore)null);
                FileInputStream myKeys = new FileInputStream(Paths.get(keystore, new String[0]).toFile());
                try {
                    KeyStore myTrustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                    myTrustStore.load(myKeys, "password".toCharArray());
                    trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    trustManagerFactory.init(myTrustStore);
                    X509TrustManager myTrustManager = null;
                    for (TrustManager tm : trustManagerFactory.getTrustManagers()) {
                        X509TrustManager x509TrustManager;
                        if (!(tm instanceof X509TrustManager)) continue;
                        myTrustManager = x509TrustManager = (X509TrustManager)tm;
                        break;
                    }
                    SSLContext context = SSLContext.getInstance("TLS");
                    context.init(null, new TrustManager[]{myTrustManager}, null);
                    sSLContext = context;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            myKeys.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                myKeys.close();
                return sSLContext;
            }
        };
    }
}

