/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.splunk.hec.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import org.apache.camel.ProducerTemplate;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Path(value="/splunk-hec")
@ApplicationScoped
public class SplunkHecResource {
    @Inject
    ProducerTemplate producer;
    @ConfigProperty(name="org.apache.camel.quarkus.component.splunk.hec.it.SplunkHecResource_hecPort")
    Integer hecPort;
    @ConfigProperty(name="org.apache.camel.quarkus.component.splunk.hec.it.SplunkHecResource_host")
    String host;
    @ConfigProperty(name="org.apache.camel.quarkus.component.splunk.hec.it.SplunkHecResource_testIndex")
    String index;
    @ConfigProperty(name="org.apache.camel.quarkus.component.splunk.hec.it.SplunkHecResource_hecToken")
    String token;

    @Path(value="/send")
    @POST
    @Produces(value={"text/plain"})
    public String send(String data, @QueryParam(value="indexTime") Long indexTime) {
        String url = String.format("splunk-hec:%s:%s?token=%s&skipTlsVerify=true&index=%s", this.host, this.hecPort, this.token, this.index);
        return (String)this.producer.requestBodyAndHeader(url, (Object)data, "CamelSplunkHECIndexTime", (Object)indexTime, String.class);
    }
}

