/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.soap.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@QuarkusTest
class SoapTest {
    SoapTest() {
    }

    @ParameterizedTest
    @ValueSource(strings={"1.1", "1.2"})
    public void testMarshal(String soapVersion) throws IOException {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("Mr Camel Quarkus SOAP V" + soapVersion).pathParam("soapVersion", (Object)soapVersion).post("/soap/marshal/{soapVersion}", new Object[0])).then()).statusCode(201)).body("Envelope.Body.getCustomersByName.name", Matchers.equalTo((Object)("Mr Camel Quarkus SOAP V" + soapVersion)), new Object[0]);
    }

    @ParameterizedTest
    @ValueSource(strings={"1.1", "1.2"})
    public void testMarshalFault(String soapVersion) {
        String prefix = "Envelope.Body.Fault";
        Object xpath = prefix;
        xpath = soapVersion.equals("1.1") ? (String)xpath + ".faultstring" : (String)xpath + ".Reason.Text";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("invalid customer").pathParam("soapVersion", (Object)soapVersion).post("/soap/marshal/fault/{soapVersion}", new Object[0])).then()).statusCode(201)).body((String)xpath, Matchers.equalTo((Object)"Specified customer was not found"), new Object[0]);
    }

    @ParameterizedTest
    @ValueSource(strings={"1.1", "1.2"})
    public void testUnmarshalSoap(String soapVersion) throws IOException {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body(this.readFile("/getCustomersByName" + soapVersion + ".xml")).pathParam("soapVersion", (Object)soapVersion).post("/soap/unmarshal/{soapVersion}", new Object[0])).then()).statusCode(201)).body(Matchers.equalTo((Object)("Mr Camel Quarkus SOAP V" + soapVersion)), new Matcher[0]);
    }

    @ParameterizedTest
    @ValueSource(strings={"1.1", "1.2"})
    public void testUnmarshalSoapFault(String soapVersion) throws IOException {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body(this.readFile("/soapFault" + soapVersion + ".xml")).pathParam("soapVersion", (Object)soapVersion).post("/soap/unmarshal/fault/{soapVersion}", new Object[0])).then()).statusCode(201)).body(Matchers.equalTo((Object)"Customer not found"), new Matcher[0]);
    }

    @Test
    public void marshalUnmarshal() {
        String msg = UUID.randomUUID().toString().replace("-", "");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(msg).post("/soap/marshal/unmarshal", new Object[0])).then()).statusCode(201)).body(Matchers.equalTo((Object)msg), new Matcher[0]);
    }

    @Test
    public void qNameStrategy() {
        String msg = UUID.randomUUID().toString().replace("-", "");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(msg).post("/soap/qname/strategy", new Object[0])).then()).statusCode(201)).body(Matchers.equalTo((Object)msg), new Matcher[0]);
    }

    @Test
    public void serviceInterfaceStrategy() {
        String msg = UUID.randomUUID().toString().replace("-", "");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(msg).post("/soap/serviceinterface/strategy", new Object[0])).then()).statusCode(201)).body(Matchers.equalTo((Object)msg), new Matcher[0]);
    }

    @Test
    public void multipart() {
        String msg = UUID.randomUUID().toString().replace("-", "");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(msg).post("/soap/multipart", new Object[0])).then()).statusCode(201)).body(Matchers.equalTo((Object)msg), new Matcher[0]);
    }

    private String readFile(String path) throws IOException {
        InputStream resource = SoapTest.class.getResourceAsStream(path);
        return IOUtils.toString((InputStream)resource, (Charset)StandardCharsets.UTF_8);
    }
}

