/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.soap.it;

import jakarta.inject.Named;
import javax.xml.namespace.QName;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.dataformat.soap.SoapDataFormat;
import org.apache.camel.dataformat.soap.name.ElementNameStrategy;
import org.apache.camel.dataformat.soap.name.QNameStrategy;
import org.apache.camel.dataformat.soap.name.ServiceInterfaceStrategy;
import org.apache.camel.dataformat.soap.name.TypeNameStrategy;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.quarkus.component.soap.it.multipart.GetCustomersByName;
import org.apache.camel.quarkus.component.soap.it.multipart.MultiPartCustomerService;
import org.apache.camel.quarkus.component.soap.it.service.CustomerService;
import org.apache.camel.quarkus.component.soap.it.service.NoSuchCustomer;
import org.apache.camel.quarkus.component.soap.it.service.NoSuchCustomerException;

public class SoapRoutes
extends RouteBuilder {
    private static final String SERVICE_CUSTOMERS_BY_NAME_PACKAGE = org.apache.camel.quarkus.component.soap.it.service.GetCustomersByName.class.getPackage().getName();
    private static final String MULTIPART_CUSTOMERS_BY_NAME_PACKAGE = GetCustomersByName.class.getPackage().getName();

    public void configure() {
        this.from("direct:marshal-soap1.1").marshal("soapDataFormat");
        this.from("direct:unmarshal-soap1.1").unmarshal("soapDataFormat");
        ((OnExceptionDefinition)this.from("direct:marshal-fault-soap1.1").onException(Exception.class).handled(true).marshal("soapDataFormat")).end().process(this.createSoapFaultProcessor());
        this.from("direct:unmarshal-fault-soap1.1").unmarshal("soapDataFormat");
        this.from("direct:unmarshalServiceInterfaceStrategy").unmarshal("soapDataFormatWithServiceInterfaceStrategy");
        this.from("direct:marshalServiceInterfaceStrategy").marshal("soapDataFormatWithServiceInterfaceStrategy");
        this.from("direct:marshalQnameStrategy").marshal().soap(SERVICE_CUSTOMERS_BY_NAME_PACKAGE, (Object)new QNameStrategy(new QName("http://service.it.soap.component.quarkus.camel.apache.org/", "getCustomersByName")));
        this.from("direct:unmarshalQnameStrategy").unmarshal().soap(SERVICE_CUSTOMERS_BY_NAME_PACKAGE, (Object)new QNameStrategy(new QName("http://service.it.soap.component.quarkus.camel.apache.org/", "getCustomersByName")));
        this.from("direct:marshal-soap1.2").marshal().soap12(SERVICE_CUSTOMERS_BY_NAME_PACKAGE);
        this.from("direct:unmarshal-soap1.2").unmarshal().soap12(SERVICE_CUSTOMERS_BY_NAME_PACKAGE);
        this.from("direct:unmarshal-fault-soap1.2").unmarshal().soap12(SERVICE_CUSTOMERS_BY_NAME_PACKAGE);
        this.from("direct:marshal-fault-soap1.2").onException(Exception.class).handled(true).marshal().soap12(SERVICE_CUSTOMERS_BY_NAME_PACKAGE).end().process(this.createSoapFaultProcessor());
        this.from("direct:marshalMultipart").marshal("soapJaxbDataFormatMultipart");
        this.from("direct:unmarshalMultipart").unmarshal("soapJaxbDataFormatMultipart");
    }

    @Named(value="soapDataFormat")
    public SoapDataFormat soapJaxbDataFormat() {
        SoapDataFormat soapJaxbDataFormat = new SoapDataFormat(SERVICE_CUSTOMERS_BY_NAME_PACKAGE, (ElementNameStrategy)new TypeNameStrategy());
        soapJaxbDataFormat.setSchema("classpath:/schema/CustomerService.xsd,classpath:/soap.xsd");
        return soapJaxbDataFormat;
    }

    @Named(value="soapDataFormatWithServiceInterfaceStrategy")
    public SoapDataFormat soapJaxbDataFormatServiceInterfaceStrategy() {
        return new SoapDataFormat(SERVICE_CUSTOMERS_BY_NAME_PACKAGE, (ElementNameStrategy)new ServiceInterfaceStrategy(CustomerService.class, true));
    }

    @Named(value="soapJaxbDataFormatMultipart")
    public SoapDataFormat soapJaxbDataFormatMultipart() {
        return new SoapDataFormat(MULTIPART_CUSTOMERS_BY_NAME_PACKAGE, (ElementNameStrategy)new ServiceInterfaceStrategy(MultiPartCustomerService.class, true));
    }

    private Processor createSoapFaultProcessor() {
        return e -> {
            org.apache.camel.quarkus.component.soap.it.service.GetCustomersByName request = (org.apache.camel.quarkus.component.soap.it.service.GetCustomersByName)e.getMessage().getBody(org.apache.camel.quarkus.component.soap.it.service.GetCustomersByName.class);
            NoSuchCustomer nsc = new NoSuchCustomer();
            nsc.setCustomerId(request.getName());
            throw new NoSuchCustomerException("Specified customer was not found", nsc);
        };
    }
}

