/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.soap.it;

import java.net.URI;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.quarkus.component.soap.it.service.GetCustomersByName;
import org.apache.camel.quarkus.component.soap.it.service.NoSuchCustomerException;
import org.jboss.logging.Logger;

@Path(value="/soap")
@ApplicationScoped
public class SoapResource {
    private static final Logger LOG = Logger.getLogger(SoapResource.class);
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    FluentProducerTemplate fluentProducerTemplate;

    @Path(value="/marshal/{soapVersion}")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"application/xml"})
    public Response marshal(@PathParam(value="soapVersion") String soapVersion, String message) throws Exception {
        LOG.infof("Sending to soap: %s", (Object)message);
        GetCustomersByName request = new GetCustomersByName();
        request.setName(message);
        String response = (String)this.fluentProducerTemplate.toF("direct:marshal-%s", new Object[]{"soap" + soapVersion}).withBody((Object)request).request(String.class);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response).build();
    }

    @Path(value="/marshal/fault/{soapVersion}")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"application/xml"})
    public Response marshalFault(@PathParam(value="soapVersion") String soapVersion, String message) throws Exception {
        LOG.infof("Sending to soap: %s", (Object)message);
        GetCustomersByName request = new GetCustomersByName();
        request.setName(message);
        String response = (String)this.fluentProducerTemplate.toF("direct:marshal-fault-%s", new Object[]{"soap" + soapVersion}).withBody((Object)request).request(String.class);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response).build();
    }

    @Path(value="/unmarshal/{soapVersion}")
    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"text/plain"})
    public Response unmarshal(@PathParam(value="soapVersion") String soapVersion, String message) throws Exception {
        GetCustomersByName response = (GetCustomersByName)this.fluentProducerTemplate.toF("direct:unmarshal-%s", new Object[]{"soap" + soapVersion}).withBody((Object)message).request(GetCustomersByName.class);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response.getName()).build();
    }

    @Path(value="/unmarshal/fault/{soapVersion}")
    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"text/plain"})
    public Response unmarshalFault(@PathParam(value="soapVersion") String soapVersion, String message) throws Exception {
        block2: {
            try {
                NoSuchCustomerException noSuchCustomerException = (NoSuchCustomerException)this.fluentProducerTemplate.toF("direct:unmarshal-fault-%s", new Object[]{"soap" + soapVersion}).withBody((Object)message).request(NoSuchCustomerException.class);
            }
            catch (CamelExecutionException e) {
                Throwable cause = e.getCause();
                if (!(cause instanceof SOAPFaultException)) break block2;
                SOAPFaultException sfe = (SOAPFaultException)cause;
                return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)sfe.getMessage()).build();
            }
        }
        return Response.serverError().entity((Object)"Expected SOAPFaultException was not thrown").build();
    }

    @Path(value="/marshal/unmarshal")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response marshalUnmarshal(String message) throws Exception {
        LOG.infof("Sending to soap: %s", (Object)message);
        GetCustomersByName request = new GetCustomersByName();
        request.setName(message);
        String xml = (String)this.producerTemplate.requestBody("direct:marshal-soap1.2", (Object)request, String.class);
        LOG.infof("Got response from marshal: %s", (Object)xml);
        GetCustomersByName response = (GetCustomersByName)this.producerTemplate.requestBody("direct:unmarshal-soap1.2", (Object)xml, GetCustomersByName.class);
        LOG.infof("Got response from unmarshal: %s", (Object)response);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response.getName()).build();
    }

    @Path(value="/qname/strategy")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response qnameStrategy(String message) throws Exception {
        GetCustomersByName request = new GetCustomersByName();
        request.setName(message);
        String xml = (String)this.producerTemplate.requestBody("direct:marshalQnameStrategy", (Object)request, String.class);
        GetCustomersByName response = (GetCustomersByName)this.producerTemplate.requestBody("direct:unmarshalQnameStrategy", (Object)xml, GetCustomersByName.class);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response.getName()).build();
    }

    @Path(value="/serviceinterface/strategy")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response serviceInterfaceStrategy(String message) throws Exception {
        GetCustomersByName request = new GetCustomersByName();
        request.setName(message);
        String xml = (String)this.producerTemplate.requestBody("direct:marshalServiceInterfaceStrategy", (Object)request, String.class);
        GetCustomersByName response = (GetCustomersByName)this.producerTemplate.requestBody("direct:unmarshalServiceInterfaceStrategy", (Object)xml, GetCustomersByName.class);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response.getName()).build();
    }
}

