/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.soap.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
class SoapTest {
    SoapTest() {
    }

    @Test
    public void testMarshal() {
        String msg = UUID.randomUUID().toString().replace("-", "");
        String resp = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(msg).post("/soap/marshal/1.1", new Object[0])).then()).statusCode(201)).extract().body().asString();
        Assertions.assertThat((String)resp).contains(new CharSequence[]{"<ns3:getCustomersByName>"});
        Assertions.assertThat((String)resp).contains(new CharSequence[]{"<name>" + msg + "</name>"});
        Assertions.assertThat((String)resp).contains(new CharSequence[]{"<ns2:Envelope xmlns:ns2=\"http://schemas.xmlsoap.org/soap/envelope/\""});
    }

    @Test
    public void testMarshalSoap12() {
        String msg = UUID.randomUUID().toString().replace("-", "");
        String resp = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(msg).post("/soap/marshal/1.2", new Object[0])).then()).statusCode(201)).extract().body().asString();
        Assertions.assertThat((String)resp).contains(new CharSequence[]{"<ns3:getCustomersByName>"});
        Assertions.assertThat((String)resp).contains(new CharSequence[]{"<name>" + msg + "</name>"});
        Assertions.assertThat((String)resp).contains(new CharSequence[]{"<ns2:Envelope xmlns:ns2=\"http://www.w3.org/2003/05/soap-envelope\""});
    }

    @Test
    public void testUnmarshalSoap() {
        String msg = UUID.randomUUID().toString().replace("-", "");
        String resp = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body(this.getSoapMessage("1.1", msg)).post("/soap/unmarshal/1.1", new Object[0])).then()).statusCode(201)).extract().body().asString();
        Assertions.assertThat((String)resp).isEqualTo(msg);
    }

    @Test
    public void testUnmarshalSoap12() {
        String msg = UUID.randomUUID().toString().replace("-", "");
        String resp = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body(this.getSoapMessage("1.2", msg)).post("/soap/unmarshal/1.2", new Object[0])).then()).statusCode(201)).extract().body().asString();
        Assertions.assertThat((String)resp).isEqualTo(msg);
    }

    @Test
    public void round() {
        String msg = UUID.randomUUID().toString().replace("-", "");
        String resp = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(msg).post("/soap/round", new Object[0])).then()).statusCode(201)).extract().body().asString();
        Assertions.assertThat((String)resp).isEqualTo(msg);
    }

    private String getSoapMessage(String namespace, String name) {
        String url = namespace.equals("1.2") ? "http://www.w3.org/2003/05/soap-envelope" : "http://schemas.xmlsoap.org/soap/envelope/";
        return "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><soap:Envelope xmlns:soap=\"" + url + "\"><soap:Body><ns2:getCustomersByName xmlns:ns2=\"http://example.it.soap.component.quarkus.camel.apache.org/\"><name>" + name + "</name></ns2:getCustomersByName></soap:Body></soap:Envelope>";
    }
}

