/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.soap.it;

import java.net.URI;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.quarkus.component.soap.it.example.GetCustomersByName;
import org.jboss.logging.Logger;

@Path(value="/soap")
@ApplicationScoped
public class SoapResource {
    private static final Logger LOG = Logger.getLogger(SoapResource.class);
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/marshal/{soapVersion}")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"application/xml"})
    public Response marshall(@PathParam(value="soapVersion") String soapVersion, String message) throws Exception {
        LOG.infof("Sending to soap: %s", (Object)message);
        GetCustomersByName request = new GetCustomersByName();
        request.setName(message);
        String endpointUri = "direct:marshal" + (soapVersion.equals("1.2") ? "-soap12" : "");
        String response = (String)this.producerTemplate.requestBody(endpointUri, (Object)request, String.class);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response).build();
    }

    @Path(value="/unmarshal/{soapVersion}")
    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"text/plain"})
    public Response unmarshal(@PathParam(value="soapVersion") String soapVersion, String message) throws Exception {
        String endpointUri = "direct:unmarshal" + (soapVersion.equals("1.2") ? "-soap12" : "");
        GetCustomersByName response = (GetCustomersByName)this.producerTemplate.requestBody(endpointUri, (Object)message, GetCustomersByName.class);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response.getName()).build();
    }

    @Path(value="/round")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response round(String message) throws Exception {
        LOG.infof("Sending to soap: %s", (Object)message);
        GetCustomersByName request = new GetCustomersByName();
        request.setName(message);
        String xml = (String)this.producerTemplate.requestBody("direct:marshal", (Object)request, String.class);
        LOG.infof("Got response from marshal: %s", (Object)xml);
        GetCustomersByName response = (GetCustomersByName)this.producerTemplate.requestBody("direct:unmarshal", (Object)xml, GetCustomersByName.class);
        LOG.infof("Got response from unmarshal: %s", (Object)response);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response.getName()).build();
    }
}

