/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.snmp.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.snmp.SnmpMessage;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class SnmpRoute
extends RouteBuilder {
    public static final String TRAP_V0_PORT = "SnmpRoute_trap_v0";
    public static final String TRAP_V1_PORT = "SnmpRoute_trap_v1";
    public static final String TRAP_V3_PORT = "SnmpRoute_trap_v3";
    @ConfigProperty(name="SnmpRoute_trap_v0")
    int trap0Port;
    @ConfigProperty(name="SnmpRoute_trap_v1")
    int trap1Port;
    @ConfigProperty(name="SnmpRoute_trap_v3")
    int trap3Port;
    @Inject
    @Named(value="snmpTrapResults")
    Map<String, Deque<SnmpMessage>> snmpResults;

    public void configure() {
        this.from("snmp:0.0.0.0:" + this.trap0Port + "?protocol=udp&type=TRAP&snmpVersion=0").process(e -> this.snmpResults.get("v0_trap").add((SnmpMessage)e.getIn().getBody(SnmpMessage.class)));
        this.from("snmp:0.0.0.0:" + this.trap1Port + "?protocol=udp&type=TRAP&snmpVersion=1").process(e -> this.snmpResults.get("v1_trap").add((SnmpMessage)e.getIn().getBody(SnmpMessage.class)));
        this.from("snmp:0.0.0.0:" + this.trap3Port + "?protocol=udp&type=TRAP&snmpVersion=3").process(e -> this.snmpResults.get("v3_trap").add((SnmpMessage)e.getIn().getBody(SnmpMessage.class)));
    }

    static class Producers {
        Producers() {
        }

        @Produces
        @Singleton
        @Named(value="snmpTrapResults")
        Map<String, Deque<SnmpMessage>> snmpResults() {
            ConcurrentHashMap<String, Deque<SnmpMessage>> map = new ConcurrentHashMap<String, Deque<SnmpMessage>>();
            map.put("v0_trap", new ConcurrentLinkedDeque());
            map.put("v1_trap", new ConcurrentLinkedDeque());
            map.put("v3_trap", new ConcurrentLinkedDeque());
            return map;
        }
    }
}

