/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.snmp.it;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.quarkus.component.snmp.it.SnmpTest;
import org.apache.camel.quarkus.test.AvailablePortFinder;
import org.apache.camel.util.CollectionHelper;
import org.junit.jupiter.api.Assertions;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.MessageException;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Snmp;
import org.snmp4j.TransportMapping;
import org.snmp4j.event.CounterListener;
import org.snmp4j.mp.CounterSupport;
import org.snmp4j.mp.DefaultCounterListener;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.StatusInformation;
import org.snmp4j.security.AuthSHA;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class SnmpTestResource
implements QuarkusTestResourceLifecycleManager {
    public static final String LISTEN_ADDRESS = "snmpListenAddress";
    public static final String LOCAL_ADDRESS = "127.0.0.1/0";
    Snmp snmpResponder;

    public Map<String, String> start() {
        DefaultUdpTransportMapping udpTransportMapping;
        SecurityProtocols.getInstance().addDefaultProtocols();
        try {
            udpTransportMapping = new DefaultUdpTransportMapping(new UdpAddress(LOCAL_ADDRESS));
            this.snmpResponder = new Snmp((TransportMapping)udpTransportMapping);
            TestCommandResponder responder = new TestCommandResponder(this.snmpResponder);
            this.snmpResponder.addCommandResponder((CommandResponder)responder);
            SecurityModels respSecModels = new SecurityModels(){};
            CounterSupport.getInstance().addCounterListener((CounterListener)new DefaultCounterListener());
            MPv3 mpv3CR = (MPv3)this.snmpResponder.getMessageDispatcher().getMessageProcessingModel(3);
            mpv3CR.setLocalEngineID(MPv3.createLocalEngineID((OctetString)new OctetString("responder")));
            respSecModels.addSecurityModel((SecurityModel)new USM(SecurityProtocols.getInstance(), new OctetString(mpv3CR.getLocalEngineID()), 0));
            mpv3CR.setSecurityModels(respSecModels);
            this.snmpResponder.getUSM().addUser(new UsmUser(new OctetString("test"), AuthSHA.ID, new OctetString("changeit"), AuthSHA.ID, new OctetString("changeit")));
            this.snmpResponder.listen();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Map ports = AvailablePortFinder.reserveNetworkPorts(Objects::toString, (String[])new String[]{"SnmpRoute_trap_v0", "SnmpRoute_trap_v1", "SnmpRoute_trap_v3"});
        Map m = CollectionHelper.mergeMaps((Map)ports, (Map[])new Map[]{CollectionHelper.mapOf((Object)LISTEN_ADDRESS, (Object)udpTransportMapping.getListenAddress().toString().replaceFirst("/", ":"), (Object[])new Object[0])});
        return m;
    }

    public void stop() {
        SecurityProtocols.setSecurityProtocols(null);
        if (this.snmpResponder != null) {
            try {
                this.snmpResponder.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static class TestCommandResponder
    implements CommandResponder {
        private final Snmp commandResponder;
        private final Map<String, Integer> counts = new ConcurrentHashMap<String, Integer>();

        public TestCommandResponder(Snmp commandResponder) {
            this.commandResponder = commandResponder;
        }

        public synchronized void processPdu(CommandResponderEvent event) {
            PDU pdu = event.getPDU();
            Vector vbs = pdu.getVariableBindings() != null ? new Vector(pdu.getVariableBindings()) : new Vector(0);
            Object key = ((Stream)vbs.stream().sequential()).map(vb -> vb.getOid().toString()).collect(Collectors.joining(","));
            key = pdu instanceof PDUv1 ? "v1_" + (String)key : (pdu instanceof ScopedPDU ? "v3_" + (String)key : "v2_" + (String)key);
            int numberOfSent = this.counts.getOrDefault(key, 0);
            try {
                PDU response = this.makeResponse(pdu, ++numberOfSent, 0, vbs);
                if (response != null) {
                    response.setRequestID(pdu.getRequestID());
                    this.commandResponder.getMessageDispatcher().returnResponsePdu(event.getMessageProcessingModel(), event.getSecurityModel(), event.getSecurityName(), event.getSecurityLevel(), response, event.getMaxSizeResponsePDU(), event.getStateReference(), new StatusInformation());
                }
            }
            catch (MessageException e) {
                Assertions.assertNull((Object)((Object)e));
            }
            this.counts.put((String)key, numberOfSent);
        }

        private PDU makeResponse(PDU originalPDU, int counter, int version, Vector<? extends VariableBinding> vbs) {
            PDU responsePDU = (PDU)originalPDU.clone();
            responsePDU.setType(-94);
            responsePDU.setErrorStatus(0);
            responsePDU.setErrorIndex(0);
            if (vbs.isEmpty()) {
                VariableBinding vb2 = this.generateResponseBinding(counter, version, SnmpTest.PRODUCE_PDU_OID);
                if (vb2 != null) {
                    responsePDU.add(vb2);
                }
            } else {
                vbs.stream().forEach(vb -> responsePDU.add(this.generateResponseBinding(counter, version, vb.getOid())));
            }
            if (responsePDU.getVariableBindings().isEmpty()) {
                return null;
            }
            return responsePDU;
        }

        private VariableBinding generateResponseBinding(int counter, int version, OID oid) {
            if (SnmpTest.GET_NEXT_OID.equals((Object)oid)) {
                if (counter < 3) {
                    return new VariableBinding(SnmpTest.GET_NEXT_OID, (Variable)new OctetString("" + counter));
                }
                if (counter == 3) {
                    return new VariableBinding(SnmpTest.GET_NEXT_OID, (Variable)new OctetString("My GET_NEXT Printer - response #" + counter));
                }
                return null;
            }
            if (SnmpTest.POLL_OID.equals((Object)oid)) {
                if (counter > 1) {
                    throw new RuntimeException(String.format("Not expected request #%d for poll of version %d.", counter, version));
                }
                return new VariableBinding(SnmpTest.POLL_OID, (Variable)new OctetString("My POLL Printer - response #" + counter));
            }
            if (SnmpTest.PRODUCE_PDU_OID.equals((Object)oid) && counter < 4) {
                return new VariableBinding(SnmpTest.PRODUCE_PDU_OID, (Variable)new OctetString("My PRODUCE_PDU Printer - response #" + counter));
            }
            if (SnmpTest.TWO_OIDS_A.equals((Object)oid) && counter < 4) {
                return new VariableBinding(SnmpTest.TWO_OIDS_A, (Variable)new OctetString("My 2 OIDs A Printer - response #" + counter));
            }
            if (SnmpTest.TWO_OIDS_B.equals((Object)oid) && counter < 4) {
                return new VariableBinding(SnmpTest.TWO_OIDS_B, (Variable)new OctetString("My 2 OIDs B Printer - response #" + counter));
            }
            if (SnmpTest.DOT_OID.equals((Object)oid)) {
                return new VariableBinding(SnmpTest.DOT_OID, (Variable)new OctetString("My DOT Printer - response #" + counter));
            }
            return null;
        }
    }
}

