/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.snmp.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.camel.quarkus.component.snmp.it.SnmpTestResource;
import org.awaitility.Awaitility;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.smi.OID;

@QuarkusTest
@QuarkusTestResource(value=SnmpTestResource.class)
class SnmpTest {
    public static final OID GET_NEXT_OID = new OID(new int[]{1, 3, 6, 1, 2, 1, 25, 3, 2, 1, 5, 1});
    public static final OID POLL_OID = SnmpConstants.sysDescr;
    public static final OID PRODUCE_PDU_OID = SnmpConstants.sysName;
    public static final OID TWO_OIDS_A = SnmpConstants.sysLocation;
    public static final OID TWO_OIDS_B = SnmpConstants.sysContact;
    public static final OID DOT_OID = new OID(new int[]{1, 3, 6, 1, 4, 1, 6527, 3, 1, 2, 21, 2, 1, 50});

    SnmpTest() {
    }

    static Stream<Integer> supportedVersions() {
        return Stream.of(0, 1);
    }

    @ParameterizedTest
    @MethodSource(value={"supportedVersions"})
    public void testSendReceiveTrap(int version) throws Exception {
        String resultsName = "v" + version + "_trap";
        ((ValidatableResponse)((Response)RestAssured.given().body("TEXT").post("/snmp/produceTrap/" + version, new Object[0])).then()).statusCode(200);
        Awaitility.await().atMost(20L, TimeUnit.SECONDS).pollDelay(100L, TimeUnit.MILLISECONDS).until(() -> {
            String result = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(SnmpConstants.snmpTrapOID.toString()).post("/snmp/results/" + resultsName, new Object[0])).then()).statusCode(200)).extract().body().asString();
            return result.contains("TEXT");
        });
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 3})
    public void testPoll(int version) throws Exception {
        RequestSpecification rs = RestAssured.given().body(POLL_OID.toString());
        if (version == 3) {
            rs.queryParam("user", new Object[]{"test"}).queryParam("securityLevel", new Object[]{1});
        }
        ((ValidatableResponse)((ValidatableResponse)((Response)rs.post("/snmp/poll/" + version, new Object[0])).then()).statusCode(200)).body(Matchers.equalTo((Object)"My POLL Printer - response #1"), new Matcher[0]);
    }

    @ParameterizedTest
    @MethodSource(value={"supportedVersions"})
    public void testPollWith2OIDs(int version) throws Exception {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(TWO_OIDS_A + "," + TWO_OIDS_B).post("/snmp/poll/" + version, new Object[0])).then()).statusCode(200)).body((Matcher)Matchers.anyOf((Matcher)Matchers.equalTo((Object)"My 2 OIDs A Printer - response #1,My 2 OIDs B Printer - response #1"), (Matcher)Matchers.equalTo((Object)"My 2 OIDs B Printer - response #1,My 2 OIDs A Printer - response #1")), new Matcher[0]);
    }

    @ParameterizedTest
    @MethodSource(value={"supportedVersions"})
    public void testPollStartingDot(int version) throws Exception {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("." + DOT_OID).post("/snmp/poll/" + version, new Object[0])).then()).statusCode(200)).body(Matchers.equalTo((Object)"My DOT Printer - response #1"), new Matcher[0]);
    }

    @ParameterizedTest
    @MethodSource(value={"supportedVersions"})
    public void testProducePDU(int version) {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(PRODUCE_PDU_OID.toString()).post("/snmp/producePDU/" + version, new Object[0])).then()).statusCode(200)).body(Matchers.startsWith((String)"My PRODUCE_PDU Printer - response #"), new Matcher[0]);
    }

    @ParameterizedTest
    @MethodSource(value={"supportedVersions"})
    public void testGetNext(int version) {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(GET_NEXT_OID.toString()).post("/snmp/getNext/" + version, new Object[0])).then()).statusCode(200)).body(Matchers.endsWith((String)"2,My GET_NEXT Printer - response #3"), new Matcher[0]);
    }
}

