/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.snmp.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.snmp.SnmpMessage;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

@Path(value="/snmp")
@ApplicationScoped
public class SnmpResource {
    @ConfigProperty(name="SnmpRoute_trap_v0")
    int trap0Port;
    @ConfigProperty(name="SnmpRoute_trap_v1")
    int trap1Port;
    @ConfigProperty(name="snmpListenAddress")
    String snmpListenAddress;
    @Inject
    @Named(value="snmpTrapResults")
    Map<String, Deque<SnmpMessage>> snmpResults;
    @Inject
    ConsumerTemplate consumerTemplate;
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/producePDU/{version}")
    @POST
    @Produces(value={"text/plain"})
    public Response producePDU(@PathParam(value="version") int version, String payload) {
        String url = String.format("snmp://%s?retries=1&snmpVersion=%d", this.snmpListenAddress, version);
        SnmpMessage pdu = (SnmpMessage)this.producerTemplate.requestBody(url, (Object)version, SnmpMessage.class);
        String response = pdu.getSnmpMessage().getVariableBindings().stream().map(vb -> vb.getVariable().toString()).collect(Collectors.joining());
        return Response.ok((Object)response).build();
    }

    @Path(value="/getNext/{version}")
    @POST
    @Produces(value={"text/plain"})
    public Response getNext(String payload, @PathParam(value="version") int version) {
        String url = String.format("snmp://%s?type=GET_NEXT&retries=1&protocol=udp&oids=%s&snmpVersion=%d", this.snmpListenAddress, payload, version);
        List pdu = (List)this.producerTemplate.requestBody(url, (Object)"", List.class);
        String response = pdu.stream().flatMap(m -> m.getSnmpMessage().getVariableBindings().stream()).filter(vb -> !"Null".equals(vb.getVariable().toString())).map(vb -> vb.getVariable().toString()).collect(Collectors.joining(","));
        return Response.ok((Object)response).build();
    }

    @Path(value="/produceTrap/{version}")
    @POST
    @Produces(value={"text/plain"})
    public Response produceTrap(String payload, @PathParam(value="version") int version) {
        int port = (new int[]{this.trap0Port, this.trap1Port, -1, -1})[version];
        String url = "snmp:127.0.0.1:" + port + "?protocol=udp&type=TRAP&snmpVersion=" + version;
        PDU trap = this.createTrap(payload, version);
        this.producerTemplate.sendBody(url, (Object)trap);
        return Response.ok().build();
    }

    @Path(value="/poll/{version}")
    @POST
    @Produces(value={"text/plain"})
    public Response poll(@PathParam(value="version") int version, @QueryParam(value="user") String user, @QueryParam(value="securityLevel") String securityLevel, String oid) {
        Object url = String.format("snmp:%s?protocol=udp&snmpVersion=%d&type=POLL&oids=%s", this.snmpListenAddress, version, oid);
        if (user != null) {
            url = (String)url + "&securityName=" + user;
        }
        if (securityLevel != null) {
            url = (String)url + "&securityLevel=" + securityLevel;
        }
        Exchange e = this.consumerTemplate.receive((String)url);
        String result = ((SnmpMessage)e.getIn().getBody(SnmpMessage.class)).getSnmpMessage().getVariableBindings().stream().filter(vb -> !"Null".equals(vb.getVariable().toString())).map(v -> v.getVariable().toString()).collect(Collectors.joining(","));
        return Response.ok((Object)result).build();
    }

    @Path(value="/results/{from}")
    @POST
    @Produces(value={"text/plain"})
    public Response results(@PathParam(value="from") String from, String oid) throws Exception {
        String result = this.snmpResults.get(from).stream().map(m -> m.getSnmpMessage().getVariable(new OID(oid)).toString()).collect(Collectors.joining(","));
        return Response.ok((Object)result).build();
    }

    public PDU createTrap(String payload, int version) {
        OID oid = new OID("1.2.3.4.5");
        OctetString var = new OctetString(payload);
        switch (version) {
            case 0: {
                PDUv1 trap0 = new PDUv1();
                trap0.setGenericTrap(6);
                trap0.setSpecificTrap(1);
                trap0.add(new VariableBinding(SnmpConstants.snmpTrapOID, (Variable)new OctetString(payload)));
                trap0.add(new VariableBinding(SnmpConstants.sysUpTime, (Variable)new TimeTicks(5000L)));
                trap0.add(new VariableBinding(SnmpConstants.sysDescr, (Variable)new OctetString("System Description")));
                trap0.setEnterprise(oid);
                trap0.add(new VariableBinding(oid, (Variable)var));
                return trap0;
            }
            case 1: {
                PDU trap1 = new PDU();
                trap1.add(new VariableBinding(SnmpConstants.snmpTrapOID, (Variable)new OctetString(payload)));
                trap1.add(new VariableBinding(SnmpConstants.sysUpTime, (Variable)new TimeTicks(5000L)));
                trap1.add(new VariableBinding(SnmpConstants.sysDescr, (Variable)new OctetString("System Description")));
                trap1.add(new VariableBinding(oid, (Variable)var));
                return trap1;
            }
        }
        return null;
    }
}

