/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.slack.it;

import java.util.Map;
import org.apache.camel.quarkus.test.wiremock.WireMockTestResourceLifecycleManager;
import org.apache.camel.util.CollectionHelper;
import org.eclipse.microprofile.config.ConfigProvider;

public class SlackTestResource
extends WireMockTestResourceLifecycleManager {
    private static final String SLACK_API_BASE_URL = "https://slack.com";
    private static final String SLACK_ENV_WEBHOOK_URL = "SLACK_WEBHOOK_URL";
    private static final String SLACK_ENV_SERVER_URL = "SLACK_SERVER_URL";
    private static final String SLACK_ENV_TOKEN = "SLACK_TOKEN";

    public Map<String, String> start() {
        Map properties = super.start();
        String wiremockUrl = (String)properties.get("wiremock.url");
        String serverUrl = wiremockUrl != null ? wiremockUrl : (String)ConfigProvider.getConfig().getValue(SLACK_ENV_SERVER_URL, String.class);
        String webhookUrl = wiremockUrl != null ? wiremockUrl + "/services/webhook" : (String)ConfigProvider.getConfig().getValue(SLACK_ENV_WEBHOOK_URL, String.class);
        return CollectionHelper.mergeMaps((Map)properties, (Map[])new Map[]{CollectionHelper.mapOf((Object)"slack.webhook.url", (Object)webhookUrl, (Object[])new Object[]{"slack.server-url", serverUrl, "slack.token", this.envOrDefault(SLACK_ENV_TOKEN, "test-token")})});
    }

    protected String getRecordTargetBaseUrl() {
        return SLACK_API_BASE_URL;
    }

    protected boolean isMockingEnabled() {
        return !this.envVarsPresent(new String[]{SLACK_ENV_WEBHOOK_URL, SLACK_ENV_SERVER_URL, SLACK_ENV_TOKEN});
    }
}

