/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.slack.it;

import com.slack.api.model.Message;
import com.slack.api.model.block.DividerBlock;
import com.slack.api.model.block.SectionBlock;
import com.slack.api.model.block.composition.MarkdownTextObject;
import com.slack.api.model.block.composition.TextObject;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.quarkus.component.slack.it.model.SlackMessageResponse;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Path(value="/slack")
@ApplicationScoped
public class SlackResource {
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    ConsumerTemplate consumerTemplate;
    @ConfigProperty(name="slack.server-url")
    String slackServerUrl;
    @ConfigProperty(name="slack.token")
    String slackToken;
    @ConfigProperty(name="slack.webhook.url")
    String slackWebHookUrl;

    @Path(value="/messages")
    @GET
    @Produces(value={"application/json"})
    public SlackMessageResponse getSlackMessages() throws Exception {
        Message message = (Message)this.consumerTemplate.receiveBody("slack://test-channel?maxResults=1&" + this.getSlackAuthParams(), 5000L, Message.class);
        return new SlackMessageResponse(message.getText(), message.getBlocks() != null ? message.getBlocks().size() : 0);
    }

    @Path(value="/message/token")
    @POST
    @Consumes(value={"text/plain"})
    public Response createSlackMessageWithToken(String message) throws Exception {
        this.producerTemplate.requestBody("slack://test-channel?" + this.getSlackAuthParams(), (Object)message);
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }

    @Path(value="/message/webhook")
    @POST
    @Consumes(value={"text/plain"})
    public Response createSlackMessageWithWebhook(String message) throws Exception {
        this.producerTemplate.requestBody(String.format("slack://test-channel?webhookUrl=%s", this.slackWebHookUrl), (Object)message);
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }

    @Path(value="/message/block")
    @POST
    @Consumes(value={"text/plain"})
    public Response createBlockMessage(String text) throws Exception {
        ArrayList<Object> blocks = new ArrayList<Object>();
        blocks.add(SectionBlock.builder().text((TextObject)MarkdownTextObject.builder().text(text).build()).build());
        blocks.add(SectionBlock.builder().fields(Arrays.asList(MarkdownTextObject.builder().text("*Testing Camel Quarkus blocks*").build(), MarkdownTextObject.builder().text("*You should be able to see these blocks").build())).build());
        blocks.add(DividerBlock.builder().build());
        Message message = new Message();
        message.setText(text);
        message.setBlocks(blocks);
        this.producerTemplate.requestBody("slack://test-channel?" + this.getSlackAuthParams(), (Object)message);
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }

    private String getSlackAuthParams() {
        return String.format("serverUrl=%s&token=%s", this.slackServerUrl, this.slackToken);
    }
}

