/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.slack.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.UUID;
import org.apache.camel.quarkus.component.slack.it.SlackTestResource;
import org.eclipse.microprofile.config.ConfigProvider;
import org.hamcrest.CoreMatchers;
import org.junit.jupiter.api.Test;

@QuarkusTest
@QuarkusTestResource(value=SlackTestResource.class)
class SlackTest {
    SlackTest() {
    }

    @Test
    public void testSlackProduceConsumeMessages() {
        String message = "Hello Camel Quarkus Slack using Token" + (String)(this.externalSlackEnabled() ? " " + UUID.randomUUID() : "");
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(message).post("/slack/message/token", new Object[0])).then()).statusCode(201);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).get("/slack/messages", new Object[0])).then()).statusCode(200)).body("text", CoreMatchers.equalTo((Object)message), new Object[0]);
        message = "Hello Camel Quarkus Slack using Webhook URL" + (String)(this.externalSlackEnabled() ? " " + UUID.randomUUID() : "");
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(message).post("/slack/message/webhook", new Object[0])).then()).statusCode(201);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).get("/slack/messages", new Object[0])).then()).statusCode(200)).body("text", CoreMatchers.equalTo((Object)message), new Object[0]);
        message = "Hello Camel Quarkus Slack using Blocks" + (String)(this.externalSlackEnabled() ? " " + UUID.randomUUID() : "");
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(message).post("/slack/message/block", new Object[0])).then()).statusCode(201);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).get("/slack/messages", new Object[0])).then()).statusCode(200)).body("text", CoreMatchers.equalTo((Object)message), new Object[]{"nbBlocks", CoreMatchers.equalTo((Object)3)});
    }

    private boolean externalSlackEnabled() {
        return !ConfigProvider.getConfig().getOptionalValue("wiremock.url", String.class).isPresent();
    }
}

