/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.sjms.it;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.io.File;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.server.embedded.EmbeddedActiveMQ;
import org.apache.camel.quarkus.component.sjms.it.CamelSjmsTest;
import org.apache.camel.quarkus.core.CamelMain;
import org.apache.camel.quarkus.test.AvailablePortFinder;
import org.apache.commons.io.FileUtils;

public class CamelSjmsTestResource
implements QuarkusTestResourceLifecycleManager {
    private CamelMain main;
    private EmbeddedActiveMQ embedded;

    public void inject(Object testInstance) {
        if (testInstance instanceof CamelSjmsTest) {
            this.main = ((CamelSjmsTest)testInstance).main;
        }
    }

    public Map<String, String> start() {
        try {
            File dataDirectory = Paths.get("./target/artemis", new String[0]).toFile();
            FileUtils.deleteDirectory((File)dataDirectory);
            int port = AvailablePortFinder.getNextAvailable();
            String url = String.format("tcp://127.0.0.1:%d", port);
            ConfigurationImpl cfg = new ConfigurationImpl();
            cfg.addAcceptorConfiguration("activemq", url);
            cfg.setSecurityEnabled(false);
            cfg.setBrokerInstance(dataDirectory);
            this.embedded = new EmbeddedActiveMQ();
            this.embedded.setConfiguration((Configuration)cfg);
            this.embedded.start();
            return Collections.singletonMap("quarkus.artemis.url", url);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not start embedded ActiveMQ server", e);
        }
    }

    public void stop() {
        try {
            if (this.main != null) {
                this.main.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.embedded != null) {
                this.embedded.stop();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not stop embedded ActiveMQ server", e);
        }
    }
}

