/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.shiro.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.apache.camel.component.shiro.security.ShiroSecurityToken;
import org.junit.jupiter.api.Test;

@QuarkusTest
class ShiroTest {
    static ShiroSecurityToken SHELDON_TOKEN = new ShiroSecurityToken("sheldon", "earth2");
    private static ShiroSecurityToken IRMA_TOKEN = new ShiroSecurityToken("irma", "password");
    private static ShiroSecurityToken FRED_TOKEN = new ShiroSecurityToken("fred", "fred");
    private static ShiroSecurityToken SEC_LEVEL1 = SHELDON_TOKEN;
    private static ShiroSecurityToken SEC_LEVEL2 = IRMA_TOKEN;
    private static ShiroSecurityToken SEC_LEVEL3 = FRED_TOKEN;
    private static ShiroSecurityToken WRONG_TOKEN = new ShiroSecurityToken("sheldon", "wrong");

    ShiroTest() {
    }

    @Test
    public void testHeaders() {
        this.test("headers", SHELDON_TOKEN, AUTHORIZATION.none, true);
        this.test("headers", WRONG_TOKEN, AUTHORIZATION.none, false);
    }

    @Test
    public void testToken() {
        this.test("token", IRMA_TOKEN, AUTHORIZATION.none, true);
        this.test("token", WRONG_TOKEN, AUTHORIZATION.none, false);
    }

    @Test
    public void testBase64() {
        this.test("base64", FRED_TOKEN, AUTHORIZATION.none, true);
        this.test("base64", WRONG_TOKEN, AUTHORIZATION.none, false);
    }

    @Test
    public void testTokenWithRoles() {
        this.test("headers", SEC_LEVEL1, AUTHORIZATION.roles, false);
        this.test("token", SEC_LEVEL2, AUTHORIZATION.roles, true);
        this.test("token", SEC_LEVEL3, AUTHORIZATION.roles, true);
    }

    @Test
    public void testTokenWithPermissions() {
        this.test("token", SEC_LEVEL1, AUTHORIZATION.permissions, false);
        this.test("headers", SEC_LEVEL2, AUTHORIZATION.permissions, true);
        this.test("headers", SEC_LEVEL3, AUTHORIZATION.permissions, true);
    }

    void test(String path, ShiroSecurityToken token, AUTHORIZATION authorization, boolean expectSuccess) {
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("expectSuccess", new Object[]{expectSuccess}).queryParam("path", new Object[]{authorization.getPath()}).contentType(ContentType.JSON).body((Object)token).post("/shiro/" + path, new Object[0])).then()).statusCode(204);
    }

    static enum AUTHORIZATION {
        none("direct:secureEndpoint"),
        roles("direct:secureWithRoles"),
        permissions("direct:secureWithPermissions");

        private String path;

        private AUTHORIZATION(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }
    }
}

