/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.shiro.it;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.camel.CamelAuthorizationException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.shiro.security.ShiroSecurityPolicy;
import org.apache.camel.quarkus.component.shiro.it.ShiroResource;
import org.apache.camel.spi.Policy;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authz.permission.WildcardPermission;

public class ShiroRouteBuilder
extends RouteBuilder {
    public static final String DIRECT_SECURE_ENDPOINT = "direct:secureEndpoint";
    public static final String DIRECT_SECURE_WITH_ROLES = "direct:secureWithRoles";
    public static final String DIRECT_SECURE_WITH_PERMISSIONS = "direct:secureWithPermissions";

    public void configure() throws Exception {
        String securityConfig = "classpath:config/securityConfig.ini";
        this.onException(new Class[]{CamelAuthorizationException.class, UnknownAccountException.class, IncorrectCredentialsException.class, LockedAccountException.class, AuthenticationException.class}).to("mock:authenticationException");
        ShiroSecurityPolicy securityPolicy = new ShiroSecurityPolicy(securityConfig, ShiroResource.passPhrase);
        securityPolicy.setBase64(true);
        this.from(DIRECT_SECURE_ENDPOINT).policy((Policy)securityPolicy).to("mock:success");
        ArrayList<String> rolesList = new ArrayList<String>();
        rolesList.add("sec-level2");
        rolesList.add("sec-level3");
        ShiroSecurityPolicy securityPolicyWithRoles = new ShiroSecurityPolicy(securityConfig, ShiroResource.passPhrase, true);
        securityPolicyWithRoles.setRolesList(rolesList);
        this.from(DIRECT_SECURE_WITH_ROLES).policy((Policy)securityPolicyWithRoles).to("mock:success");
        List<WildcardPermission> permissionsList = Collections.singletonList(new WildcardPermission("earth1:writeonly:*"));
        ShiroSecurityPolicy securityPolicyWithPermissions = new ShiroSecurityPolicy(securityConfig, ShiroResource.passPhrase, true, permissionsList);
        this.from(DIRECT_SECURE_WITH_PERMISSIONS).policy((Policy)securityPolicyWithPermissions).to("mock:success");
    }
}

