/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.shiro.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.shiro.security.ShiroSecurityToken;
import org.apache.camel.component.shiro.security.ShiroSecurityTokenInjector;
import org.jboss.logging.Logger;

@Path(value="/shiro")
@ApplicationScoped
public class ShiroResource {
    private static final Logger LOG = Logger.getLogger(ShiroResource.class);
    public static byte[] passPhrase = new byte[]{8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    CamelContext context;

    @Path(value="/headers")
    @POST
    @Consumes(value={"application/json"})
    public void headers(ShiroSecurityToken shiroSecurityToken, @QueryParam(value="expectSuccess") boolean expectSuccess, @QueryParam(value="path") String path) throws Exception {
        this.verifyMock(path, expectSuccess, exchange -> {
            exchange.getIn().setHeader("SHIRO_SECURITY_USERNAME", (Object)shiroSecurityToken.getUsername());
            exchange.getIn().setHeader("SHIRO_SECURITY_PASSWORD", (Object)shiroSecurityToken.getPassword());
        });
    }

    @Path(value="/token")
    @POST
    @Consumes(value={"application/json"})
    public void token(ShiroSecurityToken shiroSecurityToken, @QueryParam(value="expectSuccess") boolean expectSuccess, @QueryParam(value="path") String path) throws Exception {
        this.verifyMock(path, expectSuccess, exchange -> exchange.getIn().setHeader("SHIRO_SECURITY_TOKEN", (Object)shiroSecurityToken));
    }

    @Path(value="/base64")
    @POST
    @Consumes(value={"application/json"})
    public void base64(ShiroSecurityToken shiroSecurityToken, @QueryParam(value="expectSuccess") boolean expectSuccess, @QueryParam(value="path") String path) throws Exception {
        ShiroSecurityTokenInjector shiroSecurityTokenInjector = new ShiroSecurityTokenInjector(shiroSecurityToken, passPhrase);
        shiroSecurityTokenInjector.setBase64(true);
        this.verifyMock(path, expectSuccess, (Processor)shiroSecurityTokenInjector);
    }

    public void verifyMock(String path, boolean expectSuccess, Processor processor) throws Exception {
        MockEndpoint mockEndpointFailure;
        MockEndpoint mockEndpointSuccess;
        block2: {
            mockEndpointSuccess = (MockEndpoint)this.context.getEndpoint("mock:success", MockEndpoint.class);
            mockEndpointFailure = (MockEndpoint)this.context.getEndpoint("mock:authenticationException", MockEndpoint.class);
            mockEndpointSuccess.reset();
            mockEndpointFailure.reset();
            mockEndpointSuccess.expectedMessageCount(expectSuccess ? 1 : 0);
            mockEndpointFailure.expectedMessageCount(expectSuccess ? 0 : 1);
            try {
                this.producerTemplate.send(path, processor);
            }
            catch (Exception e) {
                if (!expectSuccess) break block2;
                throw e;
            }
        }
        mockEndpointSuccess.assertIsSatisfied();
        mockEndpointFailure.assertIsSatisfied();
    }
}

