/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.seda.it;

import java.net.URI;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ProducerTemplate;
import org.jboss.logging.Logger;

@Path(value="/seda")
@ApplicationScoped
public class SedaResource {
    private static final Logger LOG = Logger.getLogger(SedaResource.class);
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    ConsumerTemplate consumerTemplate;

    @Path(value="/{name}")
    @GET
    @Produces(value={"text/plain"})
    public String get(@PathParam(value="name") String name) throws Exception {
        String message = (String)this.consumerTemplate.receiveBodyNoWait("seda:" + name, String.class);
        LOG.infof("Received from seda: %s", (Object)message);
        return message;
    }

    @Path(value="/{name}")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response post(String message, @PathParam(value="name") String name) throws Exception {
        LOG.infof("Sending to seda: %s", (Object)message);
        this.producerTemplate.sendBody("seda:" + name, (Object)message);
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }
}

