/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.scheduler.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;

@Path(value="/scheduler")
@ApplicationScoped
public class SchedulerResource {
    @Inject
    CamelContext context;
    @Inject
    @Named(value="withDelayCounter")
    AtomicInteger withDelayCounter;
    @Inject
    @Named(value="useFixedDelayCounter")
    AtomicInteger useFixedDelayCounter;
    @Named(value="withDelayRepeatCounter")
    AtomicInteger withDelayRepeatCounter;
    @Inject
    @Named(value="greedyCounter")
    AtomicInteger greedyCounter;
    @Inject
    @Named(value="schedulerCounter")
    AtomicInteger schedulerCounter;

    @Path(value="/get")
    @GET
    @Produces(value={"text/plain"})
    public int get() throws Exception {
        return this.schedulerCounter.get();
    }

    @Path(value="/get-delay-count")
    @GET
    @Produces(value={"text/plain"})
    public int getCountDelay() {
        return this.withDelayCounter.get();
    }

    @Path(value="/get-fixed-delay-count")
    @GET
    @Produces(value={"text/plain"})
    public int getCountFixedDelay() {
        return this.useFixedDelayCounter.get();
    }

    @Path(value="/get-repeat-count")
    @GET
    @Produces(value={"text/plain"})
    public int getRepeatCount() {
        return this.withDelayRepeatCounter.get();
    }

    @Path(value="/get-greedy-count")
    @GET
    @Produces(value={"text/plain"})
    public int getGreedyCount() {
        return this.greedyCounter.get();
    }

    @jakarta.enterprise.inject.Produces
    @ApplicationScoped
    @Named(value="schedulerCounter")
    AtomicInteger schedulerCounter() {
        return new AtomicInteger();
    }

    @jakarta.enterprise.inject.Produces
    @ApplicationScoped
    @Named(value="withDelayRepeatCounter")
    AtomicInteger withDelayRepeatCounter() {
        return new AtomicInteger();
    }

    @jakarta.enterprise.inject.Produces
    @ApplicationScoped
    @Named(value="withDelayCounter")
    AtomicInteger withDelayCounter() {
        return new AtomicInteger();
    }

    @jakarta.enterprise.inject.Produces
    @ApplicationScoped
    @Named(value="useFixedDelayCounter")
    AtomicInteger useFixedDelayCounter() {
        return new AtomicInteger();
    }

    @jakarta.enterprise.inject.Produces
    @ApplicationScoped
    @Named(value="greedyCounter")
    AtomicInteger greedyCounter() {
        return new AtomicInteger();
    }

    @POST
    @Path(value="route/{route}/{enable}")
    public void mangeRoutes(@PathParam(value="route") String route, @PathParam(value="enable") boolean enable) throws Exception {
        if (enable) {
            this.context.getRouteController().startRoute(route);
        } else {
            this.context.getRouteController().stopRoute(route);
        }
    }
}

