/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.scheduler.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Test;

@QuarkusTest
class SchedulerTest {
    SchedulerTest() {
    }

    @Test
    public void testInitialDelay() throws Exception {
        try {
            ((ValidatableResponse)((Response)RestAssured.given().post("/scheduler/route/withInitialDelay/true", new Object[0])).then()).statusCode(204);
            Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(() -> {
                String body = ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/scheduler/get", (Object[])new Object[0]).then()).statusCode(200)).extract().body().asString();
                return !body.equals("0");
            });
        }
        finally {
            ((ValidatableResponse)((Response)RestAssured.given().post("/scheduler/route/withInitialDelay/false", new Object[0])).then()).statusCode(204);
        }
    }

    @Test
    public void testDelay() throws Exception {
        try {
            ((ValidatableResponse)((Response)RestAssured.given().post("/scheduler/route/withDelay/true", new Object[0])).then()).statusCode(204);
            Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> {
                String body = ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/scheduler/get-delay-count", (Object[])new Object[0]).then()).statusCode(200)).extract().body().asString();
                return Integer.parseInt(body) > 2;
            });
        }
        finally {
            ((ValidatableResponse)((Response)RestAssured.given().post("/scheduler/route/withDelay/false", new Object[0])).then()).statusCode(204);
        }
    }

    @Test
    public void testFixedDelay() throws Exception {
        try {
            ((ValidatableResponse)((Response)RestAssured.given().post("/scheduler/route/useFixedDelay/true", new Object[0])).then()).statusCode(204);
            Awaitility.await().atMost(2L, TimeUnit.SECONDS).until(() -> {
                String body = ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/scheduler/get-fixed-delay-count", (Object[])new Object[0]).then()).statusCode(200)).extract().body().asString();
                return Integer.parseInt(body) > 2;
            });
        }
        finally {
            ((ValidatableResponse)((Response)RestAssured.given().post("/scheduler/route/useFixedDelay/flase", new Object[0])).then()).statusCode(204);
        }
    }

    @Test
    public void testDelayWithRepeat() throws Exception {
        try {
            ((ValidatableResponse)((Response)RestAssured.given().post("/scheduler/route/withDelayRepeat/true", new Object[0])).then()).statusCode(204);
            Awaitility.await().atMost(4L, TimeUnit.SECONDS).until(() -> {
                String body = ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/scheduler/get-repeat-count", (Object[])new Object[0]).then()).statusCode(200)).extract().body().asString();
                return Integer.parseInt(body) >= 4;
            });
        }
        finally {
            ((ValidatableResponse)((Response)RestAssured.given().post("/scheduler/route/withDelayRepeat/false", new Object[0])).then()).statusCode(204);
        }
    }

    @Test
    public void testGreedyScheduler() throws Exception {
        try {
            ((ValidatableResponse)((Response)RestAssured.given().post("/scheduler/route/greedy/true", new Object[0])).then()).statusCode(204);
            Awaitility.await().atMost(2L, TimeUnit.SECONDS).until(() -> {
                String body = ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/scheduler/get-greedy-count", (Object[])new Object[0]).then()).statusCode(200)).extract().body().asString();
                return Integer.parseInt(body) > 10;
            });
        }
        finally {
            ((ValidatableResponse)((Response)RestAssured.given().post("/scheduler/route/greedy/false", new Object[0])).then()).statusCode(204);
        }
    }
}

