/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.scheduler.it;

import java.util.concurrent.atomic.AtomicInteger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.camel.builder.RouteBuilder;

@ApplicationScoped
public class SchedulerRoute
extends RouteBuilder {
    @Inject
    @Named(value="schedulerCounter")
    AtomicInteger schedulerCounter;
    @Inject
    @Named(value="withDelayCounter")
    AtomicInteger withDelayCounter;
    @Inject
    @Named(value="useFixedDelayCounter")
    AtomicInteger useFixedDelayCounter;
    @Inject
    @Named(value="withDelayRepeatCounter")
    AtomicInteger withDelayRepeatCounter;
    @Inject
    @Named(value="greedyCounter")
    AtomicInteger greedyCounter;

    public void configure() throws Exception {
        this.from("scheduler:withInitialDelay?initialDelay=1").routeId("withInitialDelay").noAutoStartup().process(e -> this.schedulerCounter.incrementAndGet());
        this.from("scheduler:withDelay?delay=100").routeId("withDelay").noAutoStartup().process(e -> this.withDelayCounter.incrementAndGet());
        this.from("scheduler:useFixedDelay?initialDelay=200&useFixedDelay=true").routeId("useFixedDelay").noAutoStartup().process(e -> this.useFixedDelayCounter.incrementAndGet());
        this.from("scheduler:withDelayRepeat?delay=1&repeatCount=5").routeId("withDelayRepeat").noAutoStartup().process(e -> this.withDelayRepeatCounter.incrementAndGet());
        this.from("scheduler:greedy?delay=100&greedy=true").routeId("greedy").noAutoStartup().process(e -> this.greedyCounter.incrementAndGet());
    }
}

