/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.scheduler.it;

import java.util.concurrent.atomic.AtomicInteger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.apache.camel.CamelContext;

@Path(value="/scheduler")
@ApplicationScoped
public class SchedulerResource {
    @Inject
    CamelContext context;
    @Inject
    @Named(value="withDelayCounter")
    AtomicInteger withDelayCounter;
    @Inject
    @Named(value="useFixedDelayCounter")
    AtomicInteger useFixedDelayCounter;
    @Named(value="withDelayRepeatCounter")
    AtomicInteger withDelayRepeatCounter;
    @Inject
    @Named(value="greedyCounter")
    AtomicInteger greedyCounter;
    @Inject
    @Named(value="schedulerCounter")
    AtomicInteger schedulerCounter;

    @Path(value="/get")
    @GET
    @javax.ws.rs.Produces(value={"text/plain"})
    public int get() throws Exception {
        return this.schedulerCounter.get();
    }

    @Path(value="/get-delay-count")
    @GET
    @javax.ws.rs.Produces(value={"text/plain"})
    public int getCountDelay() {
        return this.withDelayCounter.get();
    }

    @Path(value="/get-fixed-delay-count")
    @GET
    @javax.ws.rs.Produces(value={"text/plain"})
    public int getCountFixedDelay() {
        return this.useFixedDelayCounter.get();
    }

    @Path(value="/get-repeat-count")
    @GET
    @javax.ws.rs.Produces(value={"text/plain"})
    public int getRepeatCount() {
        return this.withDelayRepeatCounter.get();
    }

    @Path(value="/get-greedy-count")
    @GET
    @javax.ws.rs.Produces(value={"text/plain"})
    public int getGreedyCount() {
        return this.greedyCounter.get();
    }

    @Produces
    @ApplicationScoped
    @Named(value="schedulerCounter")
    AtomicInteger schedulerCounter() {
        return new AtomicInteger();
    }

    @Produces
    @ApplicationScoped
    @Named(value="withDelayRepeatCounter")
    AtomicInteger withDelayRepeatCounter() {
        return new AtomicInteger();
    }

    @Produces
    @ApplicationScoped
    @Named(value="withDelayCounter")
    AtomicInteger withDelayCounter() {
        return new AtomicInteger();
    }

    @Produces
    @ApplicationScoped
    @Named(value="useFixedDelayCounter")
    AtomicInteger useFixedDelayCounter() {
        return new AtomicInteger();
    }

    @Produces
    @ApplicationScoped
    @Named(value="greedyCounter")
    AtomicInteger greedyCounter() {
        return new AtomicInteger();
    }

    @POST
    @Path(value="route/{route}/{enable}")
    public void mangeRoutes(@PathParam(value="route") String route, @PathParam(value="enable") boolean enable) throws Exception {
        if (enable) {
            this.context.getRouteController().startRoute(route);
        } else {
            this.context.getRouteController().stopRoute(route);
        }
    }
}

