/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.saxon.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

@QuarkusTest
class SaxonXQueryTest {
    SaxonXQueryTest() {
    }

    @Test
    public void xqueyrFilterShouldMatchJames() {
        String xml = "<person name='James' city='London'/>";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(xml).get("/xquery/filter", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"JAMES"), new Matcher[0]);
    }

    @Test
    public void xqueryTransformShouldConcatEmployeeIdAndSuffix() throws IOException {
        String xml = IOUtils.resourceToString((String)"myinput.xml", (Charset)StandardCharsets.UTF_8, (ClassLoader)Thread.currentThread().getContextClassLoader());
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(xml).get("/xquery/transform", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"123Suffix"), new Matcher[0]);
    }

    @Test
    public void xqueryFromResourceShouldReturnLondon() {
        String xml = "<person name='James' city='London'/>";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(xml).get("/xquery/resource", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"London"), new Matcher[0]);
    }

    @Test
    public void produceToXQueryComponentShouldTransformMessage() {
        String expectedXml = "<transformed subject=\"Hey\"><mail><subject>Hey</subject><body>Hello world!</body></mail></transformed>";
        String xml = "<mail><subject>Hey</subject><body>Hello world!</body></mail>";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(xml).get("/xquery/produce", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)expectedXml), new Matcher[0]);
    }

    @Test
    public void customExtensionShouldTransformMessage() {
        String expectedXml = "<transformed extension-function-render=\"arg1[test]\"/>";
        String xml = "<body>test</body>";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(xml).get("/xquery/extension", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)expectedXml), new Matcher[0]);
    }

    @Test
    public void xqueryAnnotationOnBeanParameterShouldExtractFooId() {
        String expected = "Foo id is 'bar'";
        String xml = "<foo id='bar'>hello</foo>";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(xml).get("/xquery/bean", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)expected), new Matcher[0]);
    }
}

