/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.saxon.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

@QuarkusTest
class SaxonXPathTest {
    SaxonXPathTest() {
    }

    @Test
    public void xpathOnboardingSaxonViaFactoryOptionShouldSucceed() {
        String xml = "<items count='2'/>";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(xml).get("/xpath/factory", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Multiple items via factory option"), new Matcher[0]);
    }

    @Test
    public void xpathOnboardingSaxonViaObjectModelOptionShouldSucceed() {
        String xml = "<items count='3'/>";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(xml).get("/xpath/objectModel", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Multiple items via objectModel option"), new Matcher[0]);
    }

    @Test
    public void xpathOnboardingSaxonViaSaxonOptionShouldSucceed() {
        String xml = "<items count='4'/>";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(xml).get("/xpath/saxon", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Multiple items via saxon option"), new Matcher[0]);
    }

    @Test
    public void saxonXpathWithFunctionShouldReturnPriceSumLessThan25() {
        String xml = "<items><item price='1'/><item price='2'/><item price='3'/><item price='4'/></items>";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(xml).get("/xpath/function", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Price sum <= 25"), new Matcher[0]);
    }

    @Test
    public void saxonXpathWithFunctionShouldReturnPriceSumGreaterThan25() {
        String xml = "<items><item price='1'/><item price='2'/><item price='3'/><item price='40'/></items>";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(xml).get("/xpath/function", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Price sum > 25"), new Matcher[0]);
    }
}

