/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.sap.netweaver.it;

import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import org.apache.camel.ProducerTemplate;

@Path(value="/sap-netweaver")
public class SapNetweaverResource {
    private static final String SAP_COMMAND = "FlightCollection(carrid='AA',connid='0017',fldate=datetime'2017-10-05T00%3A00%3A00')";
    @Inject
    ProducerTemplate producerTemplate;

    @GET
    @Path(value="/json")
    @Produces(value={"text/plain"})
    public String getSapNetweaverJson(@QueryParam(value="test-port") int port) {
        return (String)this.producerTemplate.requestBodyAndHeader("sap-netweaver:http://localhost:" + port + "/sap/api/json", null, "CamelNetWeaverCommand", (Object)SAP_COMMAND, String.class);
    }

    @GET
    @Path(value="/xml")
    @Produces(value={"text/plain"})
    public String getSapNetweaverXml(@QueryParam(value="test-port") int port) {
        return (String)this.producerTemplate.requestBodyAndHeader("sap-netweaver:http://localhost:" + port + "/sap/api/xml?json=false", null, "CamelNetWeaverCommand", (Object)SAP_COMMAND, String.class);
    }
}

