/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.salesforce;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.camel.component.salesforce.api.dto.RecentItem;
import org.apache.camel.component.salesforce.api.dto.SObjectBasicInfo;
import org.apache.camel.quarkus.component.salesforce.SalesforceTestResource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNot;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
@QuarkusTestResource(value=SalesforceTestResource.class)
class SalesforceTest {
    SalesforceTest() {
    }

    @Test
    public void testGetDocumentRaw() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/salesforce/document/test", (Object[])new Object[0]).then()).statusCode(200)).body("attributes.type", Matchers.is((Object)"Document"), new Object[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testGetAccountDTO() {
        String accountId = null;
        String accountName = "Camel Quarkus Account Test: " + UUID.randomUUID();
        try {
            accountId = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(accountName).post("/salesforce/account", new Object[0])).then()).statusCode(200)).extract().body().asString();
            ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)("/salesforce/account/" + accountId), (Object[])new Object[0]).then()).statusCode(200)).body("Id", Matchers.is((Object)accountId), new Object[]{"AccountNumber", IsNot.not((Matcher)Matchers.emptyString())});
            if (accountId == null) return;
        }
        catch (Throwable throwable) {
            if (accountId == null) throw throwable;
            ((ValidatableResponse)RestAssured.delete((String)("/salesforce/account/" + accountId), (Object[])new Object[0]).then()).statusCode(204);
            throw throwable;
        }
        ((ValidatableResponse)RestAssured.delete((String)("/salesforce/account/" + accountId), (Object[])new Object[0]).then()).statusCode(204);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testGetAccountByQueryRecords() {
        String accountId = null;
        String accountName = "Camel Quarkus Account Test: " + UUID.randomUUID();
        try {
            accountId = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(accountName).post("/salesforce/account", new Object[0])).then()).statusCode(200)).extract().body().asString();
            ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)("/salesforce/account/query/" + accountId), (Object[])new Object[0]).then()).statusCode(200)).body("Id", IsNot.not((Matcher)Matchers.emptyString()), new Object[]{"AccountNumber", IsNot.not((Matcher)Matchers.emptyString())});
            if (accountId == null) return;
        }
        catch (Throwable throwable) {
            if (accountId == null) throw throwable;
            ((ValidatableResponse)RestAssured.delete((String)("/salesforce/account/" + accountId), (Object[])new Object[0]).then()).statusCode(204);
            throw throwable;
        }
        ((ValidatableResponse)RestAssured.delete((String)("/salesforce/account/" + accountId), (Object[])new Object[0]).then()).statusCode(204);
    }

    @Test
    public void testBulkJobApi() {
        JsonPath jobInfo = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().post("/salesforce/bulk", new Object[0])).then()).statusCode(200)).extract().body().jsonPath();
        String id = jobInfo.getString("id");
        String state = jobInfo.getString("state");
        Assertions.assertNotNull((Object)id);
        Assertions.assertTrue((id.length() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)"OPEN", (Object)state);
        jobInfo = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("jobId", new Object[]{id}).delete("/salesforce/bulk", new Object[0])).then()).statusCode(200)).extract().body().jsonPath();
        state = jobInfo.getString("state");
        Assertions.assertEquals((Object)"ABORTED", (Object)state);
    }

    @Test
    void testGlobalObjectsWithHeaders() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/salesforce/sobjects/force-limit", new Object[0])).then()).statusCode(200)).body(Matchers.containsString((String)"api-usage="), new Matcher[0]);
    }

    @Test
    void testGetVersions() {
        List versions = (List)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/salesforce/versions", new Object[0])).then()).statusCode(200)).extract().body().as(List.class);
        Assertions.assertNotNull((Object)versions);
        Assertions.assertNotEquals((int)0, (int)versions.size());
    }

    @Test
    void testGetRestResources() {
        JsonPath resources = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/salesforce/resources", new Object[0])).then()).statusCode(200)).extract().body().jsonPath();
        resources.getMap("$.").values().stream().map(Object::toString).filter(path -> path.startsWith("/services")).forEach(value -> Assertions.assertTrue((boolean)value.matches("/services/data/.*/.*")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    void testAccountWithBasicInfo() {
        String accountId = null;
        String accountName = "Camel Quarkus Account Test: " + UUID.randomUUID();
        try {
            accountId = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(accountName).post("/salesforce/account", new Object[0])).then()).statusCode(200)).extract().body().asString();
            SObjectBasicInfo accountBasicInfo = (SObjectBasicInfo)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/salesforce/basic-info/account", new Object[0])).then()).statusCode(200)).extract().body().as(SObjectBasicInfo.class);
            Assertions.assertNotNull((Object)accountBasicInfo);
            List recentItems = accountBasicInfo.getRecentItems();
            Assertions.assertNotNull((Object)recentItems);
            boolean accountIdMatched = false;
            for (RecentItem recentItem : recentItems) {
                if (!recentItem.getAttributes().getUrl().contains(accountId)) continue;
                accountIdMatched = true;
                break;
            }
            Assertions.assertTrue((boolean)accountIdMatched);
            ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)("/salesforce/account/" + accountId), (Object[])new Object[0]).then()).statusCode(200)).body("Id", IsNot.not((Matcher)Matchers.emptyString()), new Object[]{"AccountNumber", IsNot.not((Matcher)Matchers.emptyString())});
            if (accountId == null) return;
        }
        catch (Throwable throwable) {
            if (accountId == null) throw throwable;
            ((ValidatableResponse)RestAssured.delete((String)("/salesforce/account/" + accountId), (Object[])new Object[0]).then()).statusCode(204);
            throw throwable;
        }
        ((ValidatableResponse)RestAssured.delete((String)("/salesforce/account/" + accountId), (Object[])new Object[0]).then()).statusCode(204);
    }

    @Test
    void testGetAccountDescription() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/salesforce/describe/account", new Object[0])).then()).statusCode(200)).body(Matchers.notNullValue(), new Matcher[0]);
    }

    @Test
    void testLimits() {
        Map limits = (Map)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/salesforce/limits", new Object[0])).then()).statusCode(200)).extract().body().as(Map.class);
        Assertions.assertNotNull((Object)limits, (String)"Should fetch limits from Salesforce REST API");
        Assertions.assertNotNull(limits.get("ConcurrentAsyncGetReportInstances"));
        Assertions.assertNotNull(limits.get("ConcurrentSyncReportRuns"));
        Assertions.assertNotNull(limits.get("DailyApiRequests"));
        Assertions.assertNotNull(limits.get("DailyAsyncApexExecutions"));
        Assertions.assertNotNull(limits.get("DailyBulkApiRequests"));
    }
}

