/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.salesforce;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Named;
import java.util.Optional;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.salesforce.AuthenticationType;
import org.apache.camel.component.salesforce.SalesforceComponent;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.quarkus.component.salesforce.generated.Account;
import org.apache.camel.quarkus.component.salesforce.model.TestEventPojo;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class SalesforceRoutes
extends RouteBuilder {
    @ConfigProperty(name="SALESFORCE_USERNAME", defaultValue="username")
    String username;
    @ConfigProperty(name="SALESFORCE_PASSWORD", defaultValue="password")
    String password;
    @ConfigProperty(name="SALESFORCE_CLIENTID", defaultValue="clientId")
    String clientId;
    @ConfigProperty(name="SALESFORCE_CLIENTSECRET", defaultValue="clientSecret")
    String clientSecret;

    @Named(value="salesforce")
    SalesforceComponent salesforceComponent() {
        Optional wireMockUrl = ConfigProvider.getConfig().getOptionalValue("wiremock.url", String.class);
        SalesforceComponent salesforceComponent = new SalesforceComponent();
        salesforceComponent.setClientId(this.clientId);
        salesforceComponent.setClientSecret(this.clientSecret);
        salesforceComponent.setUserName(this.username);
        salesforceComponent.setPassword(this.password);
        salesforceComponent.setPackages("org.apache.camel.quarkus.component.salesforce.generated");
        if (wireMockUrl.isPresent()) {
            salesforceComponent.setAuthenticationType(AuthenticationType.USERNAME_PASSWORD);
            salesforceComponent.setRefreshToken("refreshToken");
            salesforceComponent.setLoginUrl((String)wireMockUrl.get());
        } else {
            salesforceComponent.setLoginUrl("https://login.salesforce.com");
        }
        return salesforceComponent;
    }

    public void configure() throws Exception {
        Optional wireMockUrl = ConfigProvider.getConfig().getOptionalValue("wiremock.url", String.class);
        if (!wireMockUrl.isPresent()) {
            this.from("salesforce:subscribe:/data/AccountChangeEvent?replayId=-1").routeId("cdc").autoStartup(false).to("seda:events");
            this.from("salesforce:subscribe:CamelTestTopic?notifyForFields=ALL&notifyForOperationCreate=true&notifyForOperationDelete=true&notifyForOperationUpdate=true&sObjectClass=" + Account.class.getName() + "&updateTopic=true&sObjectQuery=SELECT Id, Name FROM Account").to("seda:CamelTestTopic");
            this.from("salesforce:subscribe:CamelTestTopic?rawPayload=true&notifyForFields=ALL&notifyForOperationCreate=true&notifyForOperationDelete=true&notifyForOperationUpdate=true&updateTopic=true&sObjectQuery=SELECT Id, Name FROM Account").to("seda:RawPayloadCamelTestTopic");
            ((ProcessorDefinition)this.from("timer:platform").autoStartup(false).routeId("platformEventTimer").setBody().simple("{\"Test_Field__c\": \"data\"}")).to("salesforce:createSObject?sObjectName=TestEvent__e");
            ((RouteDefinition)this.from("direct:pubSubPublish").log("Sent Salesforce topic message: ${body}")).to("salesforce:pubSubPublish:/event/TestEvent__e");
            ((RouteDefinition)this.from("salesforce:pubSubSubscribe:/event/TestEvent__e").routeId("topicSubscribeAvro").autoStartup(false).log("Received Salesforce AVRO topic message: ${body}")).to("seda:pubSubSubscribeAvro");
            ((RouteDefinition)this.from("salesforce:pubSubSubscribe:/event/TestEvent__e?pubSubDeserializeType=GENERIC_RECORD").routeId("topicSubscribeGenericRecord").autoStartup(false).log("Received Salesforce GENERIC_RECORD topic message: ${body}")).to("seda:pubSubSubscribeGenericRecord");
            ((RouteDefinition)this.from("salesforce:pubSubSubscribe:/event/TestEvent__e?pubSubDeserializeType=JSON").routeId("topicSubscribeJson").autoStartup(false).log("Received Salesforce JSON topic message: ${body}")).to("seda:pubSubSubscribeJson");
            ((RouteDefinition)this.from("salesforce:pubSubSubscribe:/event/TestEvent__e?pubSubDeserializeType=POJO&pubSubPojoClass=" + TestEventPojo.class.getName()).routeId("topicSubscribePojo").autoStartup(false).log("Received Salesforce POJO topic message: ${body}")).to("seda:pubSubSubscribePojo");
        }
    }
}

