/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.salesforce;

import com.sforce.eventbus.TestEvent__e;
import jakarta.inject.Inject;
import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Exchange;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.component.salesforce.api.dto.AbstractDescribedSObjectBase;
import org.apache.camel.component.salesforce.api.dto.Attributes;
import org.apache.camel.component.salesforce.api.dto.CreateSObjectResult;
import org.apache.camel.component.salesforce.api.dto.GlobalObjects;
import org.apache.camel.component.salesforce.api.dto.Limits;
import org.apache.camel.component.salesforce.api.dto.RecentItem;
import org.apache.camel.component.salesforce.api.dto.SObjectBasicInfo;
import org.apache.camel.component.salesforce.api.dto.SObjectDescription;
import org.apache.camel.component.salesforce.api.dto.Version;
import org.apache.camel.component.salesforce.api.dto.bulk.ContentType;
import org.apache.camel.component.salesforce.api.dto.bulk.JobInfo;
import org.apache.camel.component.salesforce.api.dto.bulk.OperationEnum;
import org.apache.camel.component.salesforce.api.utils.QueryHelper;
import org.apache.camel.component.salesforce.internal.dto.PushTopic;
import org.apache.camel.component.salesforce.internal.dto.QueryRecordsPushTopic;
import org.apache.camel.quarkus.component.salesforce.generated.Account;
import org.apache.camel.quarkus.component.salesforce.generated.QueryRecordsAccount;
import org.apache.camel.quarkus.component.salesforce.model.GlobalObjectsAndHeaders;
import org.apache.camel.quarkus.component.salesforce.model.TestEventPojo;
import org.apache.camel.spi.RouteController;

@Path(value="/salesforce")
public class SalesforceResource {
    @Inject
    FluentProducerTemplate template;
    @Inject
    ConsumerTemplate consumerTemplate;
    @Inject
    CamelContext context;

    @Path(value="/document/{id}")
    @GET
    @Produces(value={"application/json"})
    public String getDocument(@PathParam(value="id") String id) {
        return (String)this.template.withBody((Object)id).withHeader("sObjectIdName", (Object)"Name").withHeader("sObjectName", (Object)"Document").to("salesforce:getSObjectWithId?rawPayload=true").request(String.class);
    }

    @Path(value="/account/query/{id}")
    @GET
    @Produces(value={"application/json"})
    public JsonObject getAccountByQueryRecords(@PathParam(value="id") String accountId) {
        String query = QueryHelper.queryToFetchFilteredFieldsOf((AbstractDescribedSObjectBase)new Account(), sObjectField -> sObjectField.getName().equals("Id") || sObjectField.getName().equals("AccountNumber"));
        QueryRecordsAccount request = (QueryRecordsAccount)((Object)this.template.toF("salesforce:query?sObjectQuery=%s&sObjectClass=%s", new Object[]{query + " WHERE Id = '" + accountId + "'", QueryRecordsAccount.class.getName()}).request(QueryRecordsAccount.class));
        return this.accountToJsonObject((Account)((Object)request.getRecords().get(0)));
    }

    @Path(value="/account")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public String createAccount(String accountName) {
        Account account = new Account();
        account.setName(accountName);
        account.setAccountNumber(UUID.randomUUID().toString());
        CreateSObjectResult result = (CreateSObjectResult)this.template.to("salesforce:createSObject?sObjectName=Account").withBody((Object)account).request(CreateSObjectResult.class);
        return result.getId();
    }

    @Path(value="/account/{id}")
    @DELETE
    public Response deleteAccount(@PathParam(value="id") String accountId) {
        Account account = new Account();
        account.setId(accountId);
        this.template.to("salesforce:deleteSObject").withBody((Object)account).send();
        return Response.noContent().build();
    }

    @Path(value="/account/{id}")
    @GET
    @Produces(value={"application/json"})
    public JsonObject getAccountById(@PathParam(value="id") String accountId) {
        Account account = (Account)((Object)this.template.to("salesforce:getSObjectWithId?sObjectName=Account&sObjectIdName=Id&sObjectClass=" + Account.class.getName()).withBody((Object)accountId).request(Account.class));
        return this.accountToJsonObject(account);
    }

    @Path(value="/bulk")
    @POST
    @Produces(value={"application/json"})
    public JsonObject createJob() {
        JobInfo jobInfo = this.createJobInfo();
        jobInfo.setOperation(OperationEnum.INSERT);
        JobInfo result = (JobInfo)this.template.to("salesforce:createJob").withBody((Object)jobInfo).request(JobInfo.class);
        return this.jobInfoToJsonObject(result);
    }

    @Path(value="/bulk")
    @DELETE
    @Produces(value={"application/json"})
    public JsonObject abortJob(@QueryParam(value="jobId") String jobId) {
        JobInfo jobInfo = this.createJobInfo();
        jobInfo.setId(jobId);
        JobInfo result = (JobInfo)this.template.to("salesforce:abortJob").withBody((Object)jobInfo).request(JobInfo.class);
        return this.jobInfoToJsonObject(result);
    }

    @Path(value="/route/{routeId}/{action}")
    @POST
    public Response manageRoute(@PathParam(value="routeId") String routeId, @PathParam(value="action") String action) throws Exception {
        RouteController controller = this.context.getRouteController();
        if (action.equals("start")) {
            controller.startRoute(routeId);
        } else if (action.equals("stop")) {
            controller.stopRoute(routeId);
        } else {
            throw new IllegalArgumentException("Unknown action: " + action);
        }
        return Response.ok().build();
    }

    @Path(value="/cdc")
    @GET
    @Produces(value={"application/json"})
    public Map<String, Object> getCdcEvents() {
        return (Map)this.consumerTemplate.receiveBody("seda:events", 10000L, Map.class);
    }

    @Path(value="sobjects/force-limit")
    @GET
    @Produces(value={"application/json"})
    public String getSObjectsWithForceLimitInfo() {
        Exchange exchange = this.template.to("salesforce:getGlobalObjects").withHeader("Sforce-Limit-Info", Collections.singletonList("api-usage")).send();
        GlobalObjectsAndHeaders objectsAndHeaders = new GlobalObjectsAndHeaders((GlobalObjects)exchange.getMessage().getBody(GlobalObjects.class)).withHeader("Sforce-Limit-Info", (String)exchange.getMessage().getHeader("Sforce-Limit-Info", String.class));
        return objectsAndHeaders.getHeader("Sforce-Limit-Info");
    }

    @Path(value="versions")
    @GET
    @Produces(value={"application/json"})
    public List<String> getListVersions() {
        List versions = (List)this.template.to("salesforce:getVersions").request(List.class);
        return versions.stream().map(Version::getVersion).collect(Collectors.toList());
    }

    @Path(value="resources")
    @GET
    @Produces(value={"application/json"})
    public Map<String, String> getListResources() {
        return (Map)this.template.to("salesforce:getResources").request(Map.class);
    }

    @Path(value="basic-info/account")
    @GET
    public JsonObject getAccountBasicInfo() {
        SObjectBasicInfo basicInfo = (SObjectBasicInfo)this.template.to("salesforce:getBasicInfo?sObjectName=Account").request(SObjectBasicInfo.class);
        return this.basicInfoToJsonObject(basicInfo);
    }

    @Path(value="describe/account")
    @GET
    public String getAccountDescription() {
        SObjectDescription sObjectDescription = (SObjectDescription)this.template.to("salesforce:getDescription?sObjectName=Account").request(SObjectDescription.class);
        return sObjectDescription.getName();
    }

    @Path(value="limits")
    @GET
    @Produces(value={"application/json"})
    public Map<String, Integer> getLimits() {
        Limits limits = (Limits)this.template.to("salesforce:limits").request(Limits.class);
        HashMap<String, Integer> limitInfo = new HashMap<String, Integer>();
        for (Limits.Operation operation : Limits.Operation.values()) {
            Limits.Usage usage = limits.forOperation(operation.name());
            limitInfo.put(operation.name(), usage.getRemaining());
        }
        return limitInfo;
    }

    @Path(value="streaming")
    @GET
    @Produces(value={"application/json"})
    public String getSubscribedObjects() {
        Account account = (Account)((Object)this.consumerTemplate.receiveBody("seda:CamelTestTopic", 10000L, Account.class));
        return account.getName();
    }

    @Path(value="streaming/raw")
    @GET
    @Produces(value={"application/json"})
    public String getRawSubscribedObjects() {
        return (String)this.consumerTemplate.receiveBody("seda:RawPayloadCamelTestTopic", 10000L, String.class);
    }

    @Path(value="/topic/{id}")
    @DELETE
    public Response deleteTopic(@PathParam(value="id") String topicId) {
        PushTopic topic = new PushTopic();
        topic.setId(topicId);
        this.template.to("salesforce:deleteSObject").withBody((Object)topic).send();
        return Response.noContent().build();
    }

    @Path(value="/topic")
    @GET
    public String getTopicId() {
        QueryRecordsPushTopic queryRecordsPushTopic = (QueryRecordsPushTopic)this.template.to("salesforce:query?sObjectQuery=SELECT Id FROM PushTopic WHERE Name = 'CamelTestTopic'&sObjectClass=" + QueryRecordsPushTopic.class.getName()).request(QueryRecordsPushTopic.class);
        return ((PushTopic)queryRecordsPushTopic.getRecords().get(0)).getId();
    }

    @Path(value="platform/event")
    @GET
    @Produces(value={"application/json"})
    public String getPlatformEvent() {
        return (String)this.consumerTemplate.receiveBody("salesforce:subscribe:event/TestEvent__e?rawPayload=true", 10000L, String.class);
    }

    @POST
    @Path(value="/publish/event/avro")
    public void pubSubPublishAvro(@QueryParam(value="createdBy") String createdBy, @QueryParam(value="createdDate") long createdDate, @QueryParam(value="testFieldValue") String testFieldValue) {
        TestEvent__e testEvent = TestEvent__e.newBuilder().setCreatedDate(createdDate).setCreatedById(createdBy).setTestFieldC(testFieldValue).build();
        this.template.to("direct:pubSubPublish").withBody(List.of(testEvent)).request();
    }

    @POST
    @Path(value="/publish/event/generic/record")
    public void pubSubPublishGenericRecord(@QueryParam(value="createdBy") String createdBy, @QueryParam(value="createdDate") long createdDate, @QueryParam(value="testFieldValue") String testFieldValue) {
        GenericData.Record record = new GenericRecordBuilder(TestEvent__e.getClassSchema()).set("CreatedDate", (Object)createdDate).set("CreatedById", (Object)createdBy).set("Test_Field__c", (Object)testFieldValue).build();
        this.template.to("direct:pubSubPublish").withBody(List.of(record)).request();
    }

    @POST
    @Path(value="/publish/event/json")
    @Consumes(value={"application/json"})
    public void pubSubPublishJson(String json) {
        this.template.to("direct:pubSubPublish").withBody(List.of(json)).request();
    }

    @POST
    @Path(value="/publish/event/pojo")
    public void pubSubPublishPojo(@QueryParam(value="createdBy") String createdBy, @QueryParam(value="createdDate") long createdDate, @QueryParam(value="testFieldValue") String testFieldValue) {
        TestEventPojo pojo = new TestEventPojo();
        pojo.setCreatedDate(createdDate);
        pojo.setCreatedById(createdBy);
        pojo.setTest_Field__c(testFieldValue);
        this.template.to("direct:pubSubPublish").withBody(List.of(pojo)).request();
    }

    @GET
    @Path(value="/subscribe/event/avro")
    @Produces(value={"application/json"})
    public Response pubSubSubscribeAvro() {
        TestEvent__e testEvent = (TestEvent__e)((Object)this.consumerTemplate.receiveBody("seda:pubSubSubscribeAvro", 5000L, TestEvent__e.class));
        if (testEvent == null) {
            return Response.serverError().entity((Object)"testEvent was null").build();
        }
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("createdBy", testEvent.getCreatedById().toString());
        builder.add("createdDate", testEvent.getCreatedDate());
        builder.add("testFieldValue", testEvent.getTestFieldC().toString());
        return Response.ok().entity((Object)builder.build()).build();
    }

    @GET
    @Path(value="/subscribe/event/generic/record")
    @Produces(value={"application/json"})
    public Response pubSubSubscribeGenericRecord() {
        GenericRecord record = (GenericRecord)this.consumerTemplate.receiveBody("seda:pubSubSubscribeGenericRecord", 5000L, GenericRecord.class);
        if (record == null) {
            return Response.serverError().entity((Object)"record was null").build();
        }
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("createdBy", record.get("CreatedById").toString());
        builder.add("createdDate", record.get("CreatedDate").toString());
        builder.add("testFieldValue", record.get("Test_Field__c").toString());
        return Response.ok().entity((Object)builder.build()).build();
    }

    @GET
    @Path(value="/subscribe/event/json")
    @Produces(value={"application/json"})
    public String pubSubSubscribeJson() {
        return (String)this.consumerTemplate.receiveBody("seda:pubSubSubscribeJson", 5000L, String.class);
    }

    @GET
    @Path(value="/subscribe/event/pojo")
    @Produces(value={"application/json"})
    public Response pubSubSubscribePojo() {
        TestEventPojo testEvent = (TestEventPojo)this.consumerTemplate.receiveBody("seda:pubSubSubscribePojo", 5000L, TestEventPojo.class);
        if (testEvent == null) {
            return Response.serverError().entity((Object)"testEvent was null").build();
        }
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("createdBy", testEvent.getCreatedById());
        builder.add("createdDate", testEvent.getCreatedDate());
        builder.add("testFieldValue", testEvent.getTest_Field__c());
        return Response.ok().entity((Object)builder.build()).build();
    }

    private JsonObject accountToJsonObject(Account account) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("Id", account.getId());
        builder.add("AccountNumber", account.getAccountNumber());
        return builder.build();
    }

    private JobInfo createJobInfo() {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setObject(Account.class.getSimpleName());
        jobInfo.setContentType(ContentType.CSV);
        return jobInfo;
    }

    private JsonObject jobInfoToJsonObject(JobInfo jobInfo) {
        JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
        objectBuilder.add("id", jobInfo.getId());
        objectBuilder.add("state", jobInfo.getState().value().toUpperCase(Locale.US));
        return objectBuilder.build();
    }

    private JsonObject basicInfoToJsonObject(SObjectBasicInfo basicInfo) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        List recentItems = basicInfo.getRecentItems();
        JsonArrayBuilder recentItemsArrayBuilder = Json.createArrayBuilder();
        for (RecentItem recentItem : recentItems) {
            JsonObjectBuilder recentItemBuilder = Json.createObjectBuilder();
            recentItemBuilder.add("Id", recentItem.getId());
            recentItemBuilder.add("Name", recentItem.getName());
            Attributes attributes = recentItem.getAttributes();
            JsonObjectBuilder attributesObjectBuilder = Json.createObjectBuilder();
            attributesObjectBuilder.add("url", attributes.getUrl());
            recentItemBuilder.add("attributes", attributesObjectBuilder);
            recentItemsArrayBuilder.add(recentItemBuilder);
        }
        builder.add("recentItems", recentItemsArrayBuilder);
        return builder.build();
    }
}

