/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.salesforce;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.time.Instant;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledIfEnvironmentVariable;
import org.junit.jupiter.api.condition.EnabledIfEnvironmentVariables;

@EnabledIfEnvironmentVariables(value={@EnabledIfEnvironmentVariable(named="SALESFORCE_USERNAME", matches=".+"), @EnabledIfEnvironmentVariable(named="SALESFORCE_PASSWORD", matches=".+"), @EnabledIfEnvironmentVariable(named="SALESFORCE_CLIENTID", matches=".+"), @EnabledIfEnvironmentVariable(named="SALESFORCE_CLIENTSECRET", matches=".+")})
@QuarkusTest
public class SalesforceIntegrationTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCDCAndStreamingEvents() {
        String accountId = null;
        String topicId = null;
        try {
            ((ValidatableResponse)RestAssured.post((String)"/salesforce/route/cdc/start", (Object[])new Object[0]).then()).statusCode(200);
            String accountName = "Camel Quarkus Account Test: " + UUID.randomUUID();
            accountId = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(accountName).post("/salesforce/account", new Object[0])).then()).statusCode(200)).extract().body().asString();
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> {
                Map result = (Map)((Response)RestAssured.given().get("/salesforce/cdc", new Object[0])).body().as(Map.class);
                return result != null && accountName.equals(result.get("Name"));
            });
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> {
                String result = ((Response)RestAssured.given().get("/salesforce/streaming", new Object[0])).body().asString();
                return accountName.equals(result);
            });
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> {
                String result = ((Response)RestAssured.given().get("/salesforce/streaming/raw", new Object[0])).body().asString();
                return result != null && result.contains(accountName);
            });
            topicId = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/salesforce/topic", new Object[0])).then()).statusCode(200)).extract().body().asString();
            Assertions.assertNotNull((Object)topicId);
        }
        catch (Throwable throwable) {
            ((ValidatableResponse)RestAssured.post((String)"/salesforce/route/cdc/stop", (Object[])new Object[0]).then()).statusCode(200);
            if (accountId != null) {
                ((ValidatableResponse)RestAssured.delete((String)("/salesforce/account/" + accountId), (Object[])new Object[0]).then()).statusCode(204);
            }
            if (topicId != null) {
                ((ValidatableResponse)RestAssured.delete((String)("/salesforce/topic/" + topicId), (Object[])new Object[0]).then()).statusCode(204);
            }
            throw throwable;
        }
        ((ValidatableResponse)RestAssured.post((String)"/salesforce/route/cdc/stop", (Object[])new Object[0]).then()).statusCode(200);
        if (accountId != null) {
            ((ValidatableResponse)RestAssured.delete((String)("/salesforce/account/" + accountId), (Object[])new Object[0]).then()).statusCode(204);
        }
        if (topicId != null) {
            ((ValidatableResponse)RestAssured.delete((String)("/salesforce/topic/" + topicId), (Object[])new Object[0]).then()).statusCode(204);
        }
    }

    @Test
    void testPlatformEvents() {
        try {
            ((ValidatableResponse)RestAssured.post((String)"/salesforce/route/platformEventTimer/start", (Object[])new Object[0]).then()).statusCode(200);
            String event = ((Response)RestAssured.given().contentType(ContentType.JSON).get("/salesforce/platform/event", new Object[0])).asString();
            Assertions.assertTrue((boolean)event.contains("/event/TestEvent__e"));
            Assertions.assertTrue((boolean)event.contains("Test_Field__c"));
        }
        finally {
            ((ValidatableResponse)RestAssured.post((String)"/salesforce/route/platformEventTimer/stop", (Object[])new Object[0]).then()).statusCode(200);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPubSubAvro() {
        try {
            ((ValidatableResponse)RestAssured.post((String)"/salesforce/route/topicSubscribeAvro/start", (Object[])new Object[0]).then()).statusCode(200);
            String createdBy = UUID.randomUUID().toString();
            long createdDate = Instant.now().toEpochMilli();
            String testFieldValue = UUID.randomUUID().toString();
            Awaitility.await().atMost(60L, TimeUnit.SECONDS).pollInterval(10L, TimeUnit.SECONDS).pollDelay(1L, TimeUnit.SECONDS).untilAsserted(() -> {
                ((ValidatableResponse)((Response)RestAssured.given().queryParam("createdBy", new Object[]{createdBy}).queryParam("createdDate", new Object[]{createdDate}).queryParam("testFieldValue", new Object[]{testFieldValue}).post("/salesforce/publish/event/avro", new Object[0])).then()).statusCode(204);
                ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/salesforce/subscribe/event/avro", (Object[])new Object[0]).then()).statusCode(200)).body("createdBy", Matchers.is((Object)createdBy), new Object[]{"createdDate", Matchers.is((Object)createdDate), "testFieldValue", Matchers.is((Object)testFieldValue)});
            });
        }
        finally {
            ((ValidatableResponse)RestAssured.post((String)"/salesforce/route/topicSubscribeAvro/stop", (Object[])new Object[0]).then()).statusCode(200);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPubSubGenericRecord() {
        try {
            ((ValidatableResponse)RestAssured.post((String)"/salesforce/route/topicSubscribeGenericRecord/start", (Object[])new Object[0]).then()).statusCode(200);
            String createdBy = UUID.randomUUID().toString();
            long createdDate = Instant.now().toEpochMilli();
            String testFieldValue = UUID.randomUUID().toString();
            Awaitility.await().atMost(60L, TimeUnit.SECONDS).pollInterval(10L, TimeUnit.SECONDS).pollDelay(1L, TimeUnit.SECONDS).untilAsserted(() -> {
                ((ValidatableResponse)((Response)RestAssured.given().queryParam("createdBy", new Object[]{createdBy}).queryParam("createdDate", new Object[]{createdDate}).queryParam("testFieldValue", new Object[]{testFieldValue}).post("/salesforce/publish/event/generic/record", new Object[0])).then()).statusCode(204);
                ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/salesforce/subscribe/event/generic/record", (Object[])new Object[0]).then()).statusCode(200)).body("createdBy", Matchers.is((Object)createdBy), new Object[]{"createdDate", Matchers.is((Object)String.valueOf(createdDate)), "testFieldValue", Matchers.is((Object)testFieldValue)});
            });
        }
        finally {
            ((ValidatableResponse)RestAssured.post((String)"/salesforce/route/topicSubscribeGenericRecord/stop", (Object[])new Object[0]).then()).statusCode(200);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPubSubJson() {
        try {
            ((ValidatableResponse)RestAssured.post((String)"/salesforce/route/topicSubscribeJson/start", (Object[])new Object[0]).then()).statusCode(200);
            String createdBy = UUID.randomUUID().toString();
            long createdDate = Instant.now().toEpochMilli();
            String testFieldValue = UUID.randomUUID().toString();
            String json = "        {\n            \"CreatedById\": \"%s\",\n            \"CreatedDate\": %d,\n            \"Test_Field__c\": \"%s\"\n        }\n";
            Awaitility.await().atMost(60L, TimeUnit.SECONDS).pollInterval(10L, TimeUnit.SECONDS).pollDelay(1L, TimeUnit.SECONDS).untilAsserted(() -> {
                ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(json.formatted(createdBy, createdDate, testFieldValue)).post("/salesforce/publish/event/json", new Object[0])).then()).statusCode(204);
                ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/salesforce/subscribe/event/json", (Object[])new Object[0]).then()).statusCode(200)).body("CreatedById", Matchers.is((Object)createdBy), new Object[]{"CreatedDate", Matchers.is((Object)createdDate), "Test_Field__c", Matchers.is((Object)testFieldValue)});
            });
        }
        finally {
            ((ValidatableResponse)RestAssured.post((String)"/salesforce/route/topicSubscribeJson/stop", (Object[])new Object[0]).then()).statusCode(200);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPubSubPojo() {
        try {
            ((ValidatableResponse)RestAssured.post((String)"/salesforce/route/topicSubscribePojo/start", (Object[])new Object[0]).then()).statusCode(200);
            String createdBy = UUID.randomUUID().toString();
            long createdDate = Instant.now().toEpochMilli();
            String testFieldValue = UUID.randomUUID().toString();
            Awaitility.await().atMost(60L, TimeUnit.SECONDS).pollInterval(10L, TimeUnit.SECONDS).pollDelay(1L, TimeUnit.SECONDS).untilAsserted(() -> {
                ((ValidatableResponse)((Response)RestAssured.given().queryParam("createdBy", new Object[]{createdBy}).queryParam("createdDate", new Object[]{createdDate}).queryParam("testFieldValue", new Object[]{testFieldValue}).post("/salesforce/publish/event/pojo", new Object[0])).then()).statusCode(204);
                ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/salesforce/subscribe/event/pojo", (Object[])new Object[0]).then()).statusCode(200)).body("createdBy", Matchers.is((Object)createdBy), new Object[]{"createdDate", Matchers.is((Object)createdDate), "testFieldValue", Matchers.is((Object)testFieldValue)});
            });
        }
        finally {
            ((ValidatableResponse)RestAssured.post((String)"/salesforce/route/topicSubscribePojo/stop", (Object[])new Object[0]).then()).statusCode(200);
        }
    }
}

